/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.favorites;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.plugins.views.favorites.Favorite;
import org.graylog.plugins.views.favorites.FavoritesForUserDTO;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.startpage.recentActivities.ActivityType;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityEvent;
import org.graylog.plugins.views.startpage.title.StartPageItemTitleRetriever;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.users.events.UserDeletedEvent;
import org.mongojack.DBQuery;
import org.mongojack.WriteResult;

public class FavoritesService
extends PaginatedDbService<FavoritesForUserDTO> {
    public static final String COLLECTION_NAME = "favorites";
    private final StartPageItemTitleRetriever startPageItemTitleRetriever;
    private final GRNRegistry grnRegistry;

    @Inject
    protected FavoritesService(MongoConnection mongoConnection, EventBus eventBus, MongoJackObjectMapperProvider mapper, StartPageItemTitleRetriever startPageItemTitleRetriever, GRNRegistry grnRegistry) {
        super(mongoConnection, mapper, FavoritesForUserDTO.class, COLLECTION_NAME);
        eventBus.register((Object)this);
        this.startPageItemTitleRetriever = startPageItemTitleRetriever;
        this.grnRegistry = grnRegistry;
        this.db.createIndex((DBObject)new BasicDBObject("user_id", (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject("items", (Object)1));
    }

    public PaginatedResponse<Favorite> findFavoritesFor(SearchUser searchUser, Optional<String> type, int page, int perPage) {
        List items = this.findForUser(searchUser).orElse(new FavoritesForUserDTO(searchUser.getUser().getId(), List.of())).items().stream().filter(i -> type.isEmpty() || i.type().equals(type.get())).map(i -> this.startPageItemTitleRetriever.retrieveTitle((GRN)i, searchUser).map(title -> new Favorite((GRN)i, (String)title))).flatMap(Optional::stream).toList();
        return PaginatedResponse.create(COLLECTION_NAME, new PaginatedList(FavoritesService.getPage(items, page, perPage), items.size(), page, perPage));
    }

    public void addFavoriteItemFor(String in, SearchUser searchUser) {
        GRN grn = this.grnRegistry.parse(in);
        Optional<FavoritesForUserDTO> favorites = this.findForUser(searchUser);
        if (favorites.isPresent()) {
            FavoritesForUserDTO fi = favorites.get();
            if (fi.items() != null && fi.items().stream().noneMatch(g -> g.toString().equalsIgnoreCase(in))) {
                fi.items().add(0, grn);
                this.save(fi);
            }
        } else {
            FavoritesForUserDTO items = new FavoritesForUserDTO(searchUser.getUser().getId(), List.of(grn));
            this.create(items, searchUser);
        }
    }

    public void removeFavoriteItemFor(String in, SearchUser searchUser) {
        GRN grn = this.grnRegistry.parse(in);
        Optional<FavoritesForUserDTO> favorites = this.findForUser(searchUser);
        if (favorites.isPresent() && favorites.get().items() != null) {
            FavoritesForUserDTO fi = favorites.get();
            List<GRN> items = fi.items().stream().filter(i -> !i.equals(grn)).toList();
            fi.items().clear();
            fi.items().addAll(items);
            this.save(fi);
        }
    }

    Optional<FavoritesForUserDTO> findForUser(SearchUser searchUser) {
        return this.findForUser(searchUser.getUser().getId());
    }

    Optional<FavoritesForUserDTO> findForUser(String userId) {
        return this.streamQuery(DBQuery.is((String)"user_id", (Object)userId)).findAny();
    }

    public Optional<FavoritesForUserDTO> create(FavoritesForUserDTO favorite, SearchUser searchUser) {
        try {
            WriteResult result = this.db.insert((Object)favorite);
            FavoritesForUserDTO savedObject = (FavoritesForUserDTO)result.getSavedObject();
            return Optional.ofNullable(savedObject);
        }
        catch (DuplicateKeyException e) {
            throw new IllegalStateException("Unable to create a Favorites collection, collection with this id already exists : " + favorite.id());
        }
    }

    @Subscribe
    public void removeFavoriteOnEntityDeletion(RecentActivityEvent event) {
        if (event.activityType().equals((Object)ActivityType.DELETE)) {
            String grn = event.grn().toString();
            BasicDBObject query = new BasicDBObject("items", (Object)grn);
            BasicDBObject modifications = new BasicDBObject("$pull", (Object)new BasicDBObject("items", (Object)grn));
            this.db.updateMulti((DBObject)query, (DBObject)modifications);
        }
    }

    @Subscribe
    public void removeFavoriteEntityOnUserDeletion(UserDeletedEvent event) {
        this.db.remove(DBQuery.is((String)"user_id", (Object)event.userId()));
    }
}

