/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards;

import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Traverser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.BackendQuery;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.SearchType;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.Widget;

class Query {
    private static final String FIELD_ID = "id";
    private static final String FIELD_FILTER = "filter";
    private static final String FIELD_SEARCH_TYPE_ID = "id";
    private static final String FIELD_SEARCH_TYPES = "search_types";
    private static final String FIELD_QUERY = "query";
    private static final String FIELD_QUERY_STRING = "query_string";
    private static final String FIELD_TIMERANGE = "timerange";
    private static final String FIELD_SUB_FILTERS = "filters";
    private static final String FIELD_FILTER_TYPE = "type";
    private static final String TYPE_STREAM_FILTER = "stream";
    private static final String FIELD_STREAM_ID = "id";
    private final Document queryDocument;

    Query(Document queryDocument) {
        this.queryDocument = queryDocument;
    }

    String id() {
        return this.queryDocument.getString((Object)"id");
    }

    private Set<SearchType> searchTypesForIds(Set<String> searchTypeIds) {
        Collection rawSearchTypes = (Collection)this.queryDocument.get((Object)FIELD_SEARCH_TYPES, Collection.class);
        if (rawSearchTypes == null) {
            return Collections.emptySet();
        }
        HashSet searchTypes = new HashSet(rawSearchTypes);
        return searchTypes.stream().filter(searchType -> {
            String searchTypeId = searchType.getString((Object)"id");
            return searchTypeId != null && searchTypeIds.contains(searchTypeId);
        }).map(SearchType::new).collect(Collectors.toSet());
    }

    Optional<String> queryString() {
        if (!this.queryDocument.containsKey((Object)FIELD_QUERY)) {
            return Optional.empty();
        }
        Document query = (Document)this.queryDocument.get((Object)FIELD_QUERY, Document.class);
        if (!query.containsKey((Object)FIELD_QUERY_STRING) || !(query.get((Object)FIELD_QUERY_STRING) instanceof String)) {
            return Optional.empty();
        }
        return Optional.ofNullable(query.getString((Object)FIELD_QUERY_STRING));
    }

    Optional<Document> timeRange() {
        if (!this.queryDocument.containsKey((Object)FIELD_TIMERANGE)) {
            return Optional.empty();
        }
        return Optional.ofNullable((Document)this.queryDocument.get((Object)FIELD_TIMERANGE, Document.class));
    }

    private Set<Document> subFiltersOfFilter(Document filter) {
        Collection subfilters = (Collection)filter.get((Object)FIELD_SUB_FILTERS, Collection.class);
        return subfilters == null ? Collections.emptySet() : new HashSet(subfilters);
    }

    private boolean isStreamFilter(Document filter) {
        if (!filter.containsKey((Object)FIELD_FILTER_TYPE)) {
            return false;
        }
        return TYPE_STREAM_FILTER.equals(filter.getString((Object)FIELD_FILTER_TYPE));
    }

    private String extractStreamIdFromStreamFilter(Document filter) {
        return filter.getString((Object)"id");
    }

    Set<String> streams() {
        Document optionalFilter = (Document)this.queryDocument.get((Object)FIELD_FILTER, Document.class);
        return Optional.ofNullable(optionalFilter).map(filter -> {
            Traverser filterTraverser = Traverser.forTree(this::subFiltersOfFilter);
            return StreamSupport.stream(filterTraverser.breadthFirst(filter).spliterator(), false).filter(this::isStreamFilter).map(this::extractStreamIdFromStreamFilter).filter(Objects::nonNull).collect(Collectors.toSet());
        }).orElseGet(Collections::emptySet);
    }

    public void clearUnwantedProperties() {
        this.queryDocument.remove((Object)FIELD_FILTER);
        this.queryDocument.put(FIELD_QUERY, (Object)new BackendQuery(""));
        this.queryDocument.put(FIELD_TIMERANGE, (Object)new Document((Map)ImmutableMap.of((Object)FIELD_FILTER_TYPE, (Object)"relative", (Object)"range", (Object)300)));
    }

    void mergeWidgetSettingsIntoSearchTypes(Widget widget, Set<String> searchTypeIds) {
        this.searchTypesForIds(searchTypeIds).forEach(searchType -> searchType.syncWithWidget(widget));
    }
}

