/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.AutoValue_Search;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.ParameterProvider;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.graylog.plugins.views.search.rest.ExecutionStateGlobalOverride;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.QueryEntity;
import org.graylog2.contentpacks.model.entities.SearchEntity;
import org.graylog2.shared.rest.exceptions.MissingStreamPermissionException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Search
implements ContentPackable<SearchEntity>,
ParameterProvider {
    public static final String FIELD_REQUIRES = "requires";
    static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_OWNER = "owner";
    private ImmutableMap<String, Parameter> parameterIndex;

    @Id
    @ObjectId
    @Nullable
    @JsonProperty
    public abstract String id();

    @JsonProperty
    public abstract ImmutableSet<Query> queries();

    @JsonProperty
    public abstract ImmutableSet<Parameter> parameters();

    @JsonProperty(value="requires")
    public abstract Map<String, PluginMetadataSummary> requires();

    @JsonProperty(value="owner")
    public abstract Optional<String> owner();

    public Search withOwner(@Nonnull String owner) {
        return this.toBuilder().owner(owner).build();
    }

    @JsonProperty(value="created_at")
    public abstract DateTime createdAt();

    @Override
    @JsonIgnore
    public Optional<Parameter> getParameter(String parameterName) {
        return Optional.ofNullable((Parameter)this.parameterIndex.get((Object)parameterName));
    }

    public Search applyExecutionState(ExecutionState executionState) {
        if (executionState.parameterBindings().isEmpty() && executionState.queries() == null && executionState.globalOverride() == null) {
            return this;
        }
        Builder builder = this.toBuilder();
        if (!executionState.parameterBindings().isEmpty()) {
            ImmutableSet parameters = (ImmutableSet)this.parameters().stream().map(param -> param.applyBindings((Map<String, Parameter.Binding>)executionState.parameterBindings())).collect(ImmutableSet.toImmutableSet());
            builder.parameters((ImmutableSet<Parameter>)parameters);
        }
        ExecutionStateGlobalOverride globalOverride = executionState.globalOverride();
        if (executionState.queries() != null || globalOverride != null) {
            ImmutableSet queries = (ImmutableSet)this.queries().stream().filter(query -> globalOverride.keepQueries().isEmpty() || globalOverride.keepQueries().contains((Object)query.id())).map(query -> query.applyExecutionState(executionState)).collect(ImmutableSet.toImmutableSet());
            builder.queries((ImmutableSet<Query>)queries);
        }
        return builder.build();
    }

    public Search addStreamsToQueriesWithoutStreams(Supplier<Set<String>> defaultStreamsSupplier) {
        if (!this.hasQueriesWithoutStreams()) {
            return this;
        }
        Set withStreams = this.queries().stream().filter(Query::hasStreams).collect(Collectors.toSet());
        Sets.SetView withoutStreams = Sets.difference(this.queries(), withStreams);
        Set<String> defaultStreams = defaultStreamsSupplier.get();
        if (defaultStreams.isEmpty()) {
            throw new MissingStreamPermissionException("User doesn't have access to any streams", Collections.emptySet());
        }
        Set withDefaultStreams = withoutStreams.stream().map(q -> q.addStreamsToFilter(defaultStreams)).collect(Collectors.toSet());
        ImmutableSet newQueries = Sets.union(withStreams, withDefaultStreams).immutableCopy();
        return this.toBuilder().queries((ImmutableSet<Query>)newQueries).build();
    }

    private boolean hasQueriesWithoutStreams() {
        return !this.queries().stream().allMatch(Query::hasStreams);
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return Builder.create().parameters((ImmutableSet<Parameter>)ImmutableSet.of()).queries((ImmutableSet<Query>)ImmutableSet.builder().build());
    }

    public Set<String> usedStreamIds() {
        Set queryStreamIds = this.queries().stream().map(Query::usedStreamIds).reduce(Collections.emptySet(), Sets::union);
        Set searchTypeStreamIds = this.queries().stream().flatMap(q -> q.searchTypes().stream()).map(SearchType::effectiveStreams).reduce(Collections.emptySet(), Sets::union);
        return Sets.union((Set)queryStreamIds, (Set)searchTypeStreamIds);
    }

    public Set<String> streamIdsForPermissionsCheck() {
        return this.queries().stream().map(Query::streamIdsForPermissionsCheck).reduce(Collections.emptySet(), Sets::union);
    }

    public Query queryForSearchType(String searchTypeId) {
        return this.queries().stream().filter(q -> q.hasSearchType(searchTypeId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Search " + this.id() + " doesn't have a query for search type " + searchTypeId));
    }

    @Override
    public SearchEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        LinkedHashSet queries = this.queries().stream().map(query -> query.toContentPackEntity(entityDescriptorIds)).collect(Collectors.toCollection(LinkedHashSet::new));
        SearchEntity.Builder searchEntityBuilder = SearchEntity.builder().queries((ImmutableSet<QueryEntity>)ImmutableSet.copyOf((Collection)queries)).parameters(this.parameters()).requires(this.requires()).createdAt(this.createdAt());
        if (this.owner().isPresent()) {
            searchEntityBuilder.owner(this.owner().get());
        }
        return searchEntityBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @Id
        @JsonProperty
        public abstract Builder id(String var1);

        public abstract String id();

        @JsonProperty
        public abstract Builder queries(ImmutableSet<Query> var1);

        @JsonProperty
        public abstract Builder parameters(ImmutableSet<Parameter> var1);

        @JsonProperty(value="requires")
        public abstract Builder requires(Map<String, PluginMetadataSummary> var1);

        @JsonProperty(value="owner")
        public abstract Builder owner(@Nullable String var1);

        @JsonProperty(value="created_at")
        public abstract Builder createdAt(DateTime var1);

        abstract Search autoBuild();

        @JsonCreator
        public static Builder create() {
            return new AutoValue_Search.Builder().requires(Collections.emptyMap()).createdAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).parameters((ImmutableSet<Parameter>)ImmutableSet.of());
        }

        public Search build() {
            if (this.id() == null) {
                this.id(org.bson.types.ObjectId.get().toString());
            }
            Search search = this.autoBuild();
            search.parameterIndex = Maps.uniqueIndex(search.parameters(), Parameter::name);
            return search;
        }
    }
}

