/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.errors.SearchException;
import org.graylog.plugins.views.search.errors.SearchTypeError;

public interface SearchTypeHandler<S extends SearchType, Q, R> {
    default public void generateQueryPart(Query query, SearchType searchType, Q queryContext) {
        try {
            this.doGenerateQueryPart(query, searchType, queryContext);
        }
        catch (SearchException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SearchException(new SearchTypeError(query, searchType.id(), t));
        }
    }

    public void doGenerateQueryPart(Query var1, S var2, Q var3);

    default public SearchType.Result extractResult(SearchJob job, Query query, SearchType searchType, R queryResult, Q queryContext) {
        try {
            return this.doExtractResultImpl(job, query, searchType, queryResult, queryContext);
        }
        catch (SearchException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SearchException(new SearchTypeError(query, searchType.id(), t), t);
        }
    }

    public SearchType.Result doExtractResultImpl(SearchJob var1, Query var2, S var3, R var4, Q var5);
}

