/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine.validation;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchExecutionGuard;
import org.graylog.plugins.views.search.engine.validation.SearchValidation;
import org.graylog.plugins.views.search.engine.validation.SearchValidator;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.permissions.StreamPermissions;

public class PluggableSearchValidation
implements SearchValidation {
    private final SearchExecutionGuard executionGuard;
    private final Set<SearchValidator> pluggableSearchValidators;

    @Inject
    public PluggableSearchValidation(SearchExecutionGuard executionGuard, Set<SearchValidator> pluggableSearchValidators) {
        this.executionGuard = executionGuard;
        this.pluggableSearchValidators = pluggableSearchValidators;
    }

    @Override
    public Set<SearchError> validate(Search search, StreamPermissions streamPermissions) {
        this.executionGuard.check(search, streamPermissions::canReadStream);
        return this.pluggableSearchValidators.stream().flatMap(validator -> validator.validate(search).stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<SearchError> validate(Query query, StreamPermissions streamPermissions) {
        this.executionGuard.checkUserIsPermittedToSeeStreams(query.streamIdsForPermissionsCheck(), streamPermissions::canReadStream);
        return this.pluggableSearchValidators.stream().flatMap(validator -> validator.validate(query).stream()).collect(Collectors.toSet());
    }
}

