/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.errors;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog2.shared.utilities.ExceptionUtils;

public class QueryError
implements SearchError {
    private final Query query;
    @Nullable
    private final Throwable throwable;
    private final String description;
    private final boolean fatal;

    public QueryError(@Nonnull Query query, Throwable throwable) {
        this(query, ExceptionUtils.getRootCauseMessage(throwable));
    }

    public QueryError(@Nonnull Query query, String description) {
        this(query, null, description, false);
    }

    public QueryError(@Nonnull Query query, String description, boolean fatal) {
        this(query, null, description, fatal);
    }

    public QueryError(Query query, @Nullable Throwable throwable, String description, boolean fatal) {
        this.query = query;
        this.throwable = throwable;
        this.description = description;
        this.fatal = fatal;
    }

    @JsonProperty(value="query_id")
    public String queryId() {
        return this.query.id();
    }

    @Override
    public String description() {
        return this.description;
    }

    @Nullable
    @JsonProperty(value="backtrace")
    public String backtrace() {
        if (this.throwable == null) {
            return null;
        }
        return org.apache.commons.lang.exception.ExceptionUtils.getFullStackTrace((Throwable)this.throwable);
    }

    @Override
    public boolean fatal() {
        return this.fatal;
    }
}

