/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.glassfish.jersey.server.ChunkedOutput;
import org.graylog.plugins.views.search.export.SimpleMessage;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkedRunner.class);
    private final ChunkedOutput<SimpleMessageChunk> output = new ChunkedOutput(SimpleMessageChunk.class);

    public static ChunkedOutput<SimpleMessageChunk> runAsync(Consumer<Consumer<SimpleMessageChunk>> call) {
        ChunkedRunner r = new ChunkedRunner();
        r.run(call);
        return r.output;
    }

    private void run(Consumer<Consumer<SimpleMessageChunk>> call) {
        ExecutorService e = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("chunked-messages-request").build());
        e.submit(() -> {
            try {
                call.accept(this::write);
            }
            catch (Exception ex) {
                LOG.error("Error executing runnable", (Throwable)ex);
                this.writeExceptionAsChunk(ex);
            }
            finally {
                this.close();
            }
        });
    }

    private void writeExceptionAsChunk(Exception ex) {
        Throwable cause = ExceptionUtils.getRootCause(ex, true);
        if (cause.getSuppressed().length > 0) {
            cause = cause.getSuppressed()[0];
        }
        this.write(this.createErrChunk(cause));
    }

    private SimpleMessageChunk createErrChunk(Throwable cause) {
        LinkedHashMap<String, Object> err = new LinkedHashMap<String, Object>();
        err.put("err", cause.toString());
        LinkedHashSet<SimpleMessage> messages = new LinkedHashSet<SimpleMessage>();
        messages.add(SimpleMessage.builder().index("err").fields(err).build());
        return SimpleMessageChunk.builder().fieldsInOrder(new LinkedHashSet<String>(Collections.singletonList("err"))).chunkOrder(SimpleMessageChunk.ChunkOrder.LAST).messages(messages).build();
    }

    private void close() {
        try {
            this.output.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close ChunkedOutput", e);
        }
    }

    private void write(SimpleMessageChunk chunk) {
        try {
            this.output.write((Object)chunk);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to ChunkedOutput", e);
        }
    }
}

