/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Positive;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.export.AutoValue_MessagesRequest;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.LinkedHashSetUtil;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTimeZone;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class MessagesRequest {
    private static final String FIELD_TIMERANGE = "timerange";
    private static final String FIELD_QUERY_STRING = "query_string";
    private static final String FIELD_FIELDS = "fields_in_order";
    private static final String FIELD_CHUNK_SIZE = "chunk_size";
    private static final String FIELD_TIME_ZONE = "time_zone";

    @JsonProperty(value="timerange")
    public abstract TimeRange timeRange();

    @JsonProperty(value="query_string")
    public abstract ElasticsearchQueryString queryString();

    @JsonProperty
    public abstract Set<String> streams();

    @JsonProperty(value="fields_in_order")
    @NotEmpty
    public abstract LinkedHashSet<String> fieldsInOrder();

    @JsonProperty(value="chunk_size")
    public abstract int chunkSize();

    @JsonProperty(value="time_zone")
    public abstract Optional<DateTimeZone> timeZone();

    @JsonProperty
    @Positive
    public abstract OptionalInt limit();

    public static MessagesRequest withDefaults() {
        return MessagesRequest.builder().build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public MessagesRequest withTimeZone(@Nonnull DateTimeZone timeZone) {
        return this.toBuilder().timeZone(timeZone).build();
    }

    public MessagesRequest withStreams(@Nonnull Set<String> streams) {
        return this.toBuilder().streams(streams).build();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="timerange")
        public abstract Builder timeRange(TimeRange var1);

        @JsonProperty
        public abstract Builder streams(Set<String> var1);

        @JsonProperty(value="query_string")
        public abstract Builder queryString(ElasticsearchQueryString var1);

        @JsonProperty(value="fields_in_order")
        public abstract Builder fieldsInOrder(LinkedHashSet<String> var1);

        public Builder fieldsInOrder(String ... fieldsInOrder) {
            return this.fieldsInOrder(LinkedHashSetUtil.linkedHashSetOf(fieldsInOrder));
        }

        @JsonProperty(value="chunk_size")
        public abstract Builder chunkSize(int var1);

        @JsonProperty(value="time_zone")
        public abstract Builder timeZone(DateTimeZone var1);

        @JsonProperty
        public abstract Builder limit(Integer var1);

        public abstract MessagesRequest build();

        @JsonCreator
        public static Builder create() {
            return new AutoValue_MessagesRequest.Builder().timeRange(ExportMessagesCommand.defaultTimeRange()).streams(ExportMessagesCommand.DEFAULT_STREAMS).queryString(ExportMessagesCommand.DEFAULT_QUERY).fieldsInOrder(ExportMessagesCommand.DEFAULT_FIELDS).chunkSize(1000);
        }
    }
}

