/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.graylog.plugins.views.search.permissions.StreamPermissions;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.streams.StreamService;

public class PermittedStreams {
    private final Supplier<Stream<String>> allStreamsProvider;

    public PermittedStreams(Supplier<Stream<String>> allStreamsProvider) {
        this.allStreamsProvider = allStreamsProvider;
    }

    @Inject
    public PermittedStreams(StreamService streamService) {
        this(() -> streamService.loadAll().stream().map(Persisted::getId));
    }

    public ImmutableSet<String> load(StreamPermissions streamPermissions) {
        return (ImmutableSet)this.allStreamsProvider.get().filter(id -> !org.graylog2.plugin.streams.Stream.NON_MESSAGE_STREAM_IDS.contains(id)).filter(streamPermissions::canReadStream).collect(ImmutableSet.toImmutableSet());
    }
}

