/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.Uninterruptibles;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchDomain;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.db.SearchJobService;
import org.graylog.plugins.views.search.engine.SearchExecutor;
import org.graylog.plugins.views.search.events.SearchJobExecutionEvent;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.graylog.plugins.views.search.rest.SearchDTO;
import org.graylog.plugins.views.search.rest.SearchDTOv2;
import org.graylog.plugins.views.search.rest.SearchJobDTO;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Search", tags={"cloud"})
@Path(value="/views/search")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class SearchResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    private static final String BASE_PATH = "views/search";
    private static final String SEARCH_FORMAT_V1 = "application/vnd.graylog.search.v1+json";
    private static final String SEARCH_FORMAT_V2 = "application/vnd.graylog.search.v2+json";
    private final SearchDomain searchDomain;
    private final SearchExecutor searchExecutor;
    private final SearchJobService searchJobService;
    private final EventBus serverEventBus;

    @Inject
    public SearchResource(SearchDomain searchDomain, SearchExecutor searchExecutor, SearchJobService searchJobService, EventBus serverEventBus) {
        this.searchDomain = searchDomain;
        this.searchExecutor = searchExecutor;
        this.searchJobService = searchJobService;
        this.serverEventBus = serverEventBus;
    }

    @POST
    @ApiOperation(value="Create a search query", response=SearchDTO.class, code=201)
    @AuditEvent(type="views:search:create")
    @Consumes(value={"application/json", "application/vnd.graylog.search.v1+json"})
    @Produces(value={"application/json", "application/vnd.graylog.search.v1+json"})
    public Response createSearch(@ApiParam SearchDTO searchRequest, @Context SearchUser searchUser) {
        Search search = searchRequest.toSearch();
        Search saved = this.searchDomain.saveForUser(search, searchUser);
        SearchDTO result = SearchDTO.fromSearch(saved);
        if (result == null || result.id() == null) {
            return Response.serverError().build();
        }
        LOG.debug("Created new search object {}", (Object)result.id());
        return Response.created((URI)URI.create(result.id())).entity((Object)result).build();
    }

    @POST
    @ApiOperation(value="Create a search query", response=SearchDTOv2.class, code=201)
    @AuditEvent(type="views:search:create")
    @Consumes(value={"application/vnd.graylog.search.v2+json"})
    @Produces(value={"application/vnd.graylog.search.v2+json"})
    public Response createSearchV2(@ApiParam SearchDTOv2 searchRequest, @Context SearchUser searchUser) {
        Search search = searchRequest.toSearch();
        Search saved = this.searchDomain.saveForUser(search, searchUser);
        SearchDTOv2 result = SearchDTOv2.fromSearch(saved);
        if (result == null || result.id() == null) {
            return Response.serverError().build();
        }
        LOG.debug("Created new search object {}", (Object)result.id());
        return Response.created((URI)URI.create(result.id())).entity((Object)result).build();
    }

    @GET
    @ApiOperation(value="Retrieve a search query")
    @Path(value="{id}")
    @Produces(value={"application/json", "application/vnd.graylog.search.v1+json"})
    public SearchDTO getSearch(@ApiParam(name="id") @PathParam(value="id") String searchId, @Context SearchUser searchUser) {
        Search search = this.searchDomain.getForUser(searchId, searchUser).orElseThrow(() -> new NotFoundException("Search with id " + searchId + " does not exist"));
        return SearchDTO.fromSearch(search);
    }

    @GET
    @ApiOperation(value="Get all searches which the user may see")
    @Produces(value={"application/json", "application/vnd.graylog.search.v1+json"})
    public List<SearchDTO> getAllSearches(@Context SearchUser searchUser) {
        List<Search> searches = this.searchDomain.getAllForUser(searchUser, searchUser::canReadView);
        return searches.stream().map(SearchDTO::fromSearch).collect(Collectors.toList());
    }

    @POST
    @ApiOperation(value="Execute the referenced search query asynchronously", notes="Starts a new search, irrespective whether or not another is already running", response=SearchJobDTO.class)
    @Path(value="{id}/execute")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    @Produces(value={"application/json", "application/vnd.graylog.search.v1+json"})
    public Response executeQuery(@ApiParam(name="id") @PathParam(value="id") String id, @ApiParam ExecutionState executionState, @Context SearchUser searchUser) {
        SearchJob searchJob = this.searchExecutor.execute(id, searchUser, executionState);
        this.postAuditEvent(searchJob);
        SearchJobDTO searchJobDTO = SearchJobDTO.fromSearchJob(searchJob);
        return Response.created((URI)URI.create("views/search/status/" + searchJobDTO.id())).entity((Object)searchJob).build();
    }

    @POST
    @ApiOperation(value="Execute a new synchronous search", notes="Executes a new search and waits for its result", response=SearchJobDTO.class)
    @Path(value="sync")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    @Consumes(value={"application/json", "application/vnd.graylog.search.v1+json"})
    @Produces(value={"application/json", "application/vnd.graylog.search.v1+json"})
    public Response executeSyncJob(@ApiParam @NotNull(message="Search body is mandatory") @NotNull(message="Search body is mandatory") SearchDTO searchRequest, @ApiParam(name="timeout", defaultValue="60000") @QueryParam(value="timeout") @DefaultValue(value="60000") long timeout, @Context SearchUser searchUser) {
        Search search = searchRequest.toSearch();
        SearchJob searchJob = this.searchExecutor.execute(search, searchUser, ExecutionState.empty());
        this.postAuditEvent(searchJob);
        SearchJobDTO searchJobDTO = SearchJobDTO.fromSearchJob(searchJob);
        return Response.ok((Object)searchJobDTO).build();
    }

    @POST
    @ApiOperation(value="Execute a new synchronous search", notes="Executes a new search and waits for its result", response=SearchJobDTO.class)
    @Path(value="sync")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    @Consumes(value={"application/vnd.graylog.search.v2+json"})
    @Produces(value={"application/vnd.graylog.search.v2+json"})
    public Response executeSyncJobv2(@ApiParam @NotNull(message="Search body is mandatory") @NotNull(message="Search body is mandatory") SearchDTOv2 searchRequest, @ApiParam(name="timeout", defaultValue="60000") @QueryParam(value="timeout") @DefaultValue(value="60000") long timeout, @Context SearchUser searchUser) {
        Search search = searchRequest.toSearch();
        SearchJob searchJob = this.searchExecutor.execute(search, searchUser, ExecutionState.empty());
        this.postAuditEvent(searchJob);
        SearchJobDTO searchJobDTO = SearchJobDTO.fromSearchJob(searchJob);
        return Response.ok((Object)searchJobDTO).build();
    }

    @GET
    @ApiOperation(value="Retrieve the status of an executed query")
    @Path(value="status/{jobId}")
    @Produces(value={"application/json", "application/vnd.graylog.search.v1+json"})
    public SearchJobDTO jobStatus(@ApiParam(name="jobId") @PathParam(value="jobId") String jobId, @Context SearchUser searchUser) {
        SearchJob searchJob = this.searchJobService.load(jobId, searchUser.username()).orElseThrow(NotFoundException::new);
        if (searchJob != null && searchJob.getResultFuture() != null) {
            try {
                Uninterruptibles.getUninterruptibly(searchJob.getResultFuture(), (long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException exception) {
                // empty catch block
            }
        }
        return SearchJobDTO.fromSearchJob(searchJob);
    }

    private void postAuditEvent(SearchJob searchJob) {
        SearchJobExecutionEvent searchJobExecutionEvent = SearchJobExecutionEvent.create(this.getCurrentUser(), searchJob, DateTime.now((DateTimeZone)DateTimeZone.UTC));
        this.serverEventBus.post((Object)searchJobExecutionEvent);
    }
}

