/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.response.decorators;

import java.util.HashMap;
import java.util.Map;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.scriptingapi.request.RequestedField;
import org.graylog.plugins.views.search.rest.scriptingapi.response.decorators.CachingDecoratorKey;
import org.graylog.plugins.views.search.rest.scriptingapi.response.decorators.FieldDecorator;

public class CachingDecorator
implements FieldDecorator {
    private final FieldDecorator delegate;
    private final Map<CachingDecoratorKey, Object> cache = new HashMap<CachingDecoratorKey, Object>();

    public CachingDecorator(FieldDecorator delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean accept(RequestedField field) {
        return this.delegate.accept(field);
    }

    @Override
    public Object decorate(RequestedField field, Object value, SearchUser searchUser) {
        CachingDecoratorKey key = new CachingDecoratorKey(field, value, searchUser);
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, this.delegate.decorate(field, value, searchUser));
        }
        return this.cache.get(key);
    }
}

