/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.plugins.views.search.searchtypes.events.EventList;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;

final class AutoValue_EventList
extends EventList {
    private final Optional<String> name;
    private final Optional<DerivedTimeRange> timerange;
    private final Optional<BackendQuery> query;
    private final Set<String> streams;
    private final String type;
    @Nullable
    private final String id;
    @Nullable
    private final Filter filter;
    private final List<UsedSearchFilter> filters;

    private AutoValue_EventList(Optional<String> name, Optional<DerivedTimeRange> timerange, Optional<BackendQuery> query, Set<String> streams, String type, @Nullable String id, @Nullable Filter filter, List<UsedSearchFilter> filters) {
        this.name = name;
        this.timerange = timerange;
        this.query = query;
        this.streams = streams;
        this.type = type;
        this.id = id;
        this.filter = filter;
        this.filters = filters;
    }

    @Override
    @JsonProperty
    public Optional<String> name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<DerivedTimeRange> timerange() {
        return this.timerange;
    }

    @Override
    @JsonProperty
    public Optional<BackendQuery> query() {
        return this.query;
    }

    @Override
    @JsonProperty
    public Set<String> streams() {
        return this.streams;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public Filter filter() {
        return this.filter;
    }

    @Override
    @JsonProperty(value="filters")
    public List<UsedSearchFilter> filters() {
        return this.filters;
    }

    public String toString() {
        return "EventList{name=" + this.name + ", timerange=" + this.timerange + ", query=" + this.query + ", streams=" + this.streams + ", type=" + this.type + ", id=" + this.id + ", filter=" + this.filter + ", filters=" + this.filters + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EventList) {
            EventList that = (EventList)o;
            return this.name.equals(that.name()) && this.timerange.equals(that.timerange()) && this.query.equals(that.query()) && this.streams.equals(that.streams()) && this.type.equals(that.type()) && (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter())) && this.filters.equals(that.filters());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter == null ? 0 : this.filter.hashCode();
        h$ *= 1000003;
        return h$ ^= this.filters.hashCode();
    }

    @Override
    public EventList.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends EventList.Builder {
        private Optional<String> name = Optional.empty();
        private Optional<DerivedTimeRange> timerange = Optional.empty();
        private Optional<BackendQuery> query = Optional.empty();
        private Set<String> streams;
        private String type;
        private String id;
        private Filter filter;
        private List<UsedSearchFilter> filters;

        Builder() {
        }

        private Builder(EventList source) {
            this.name = source.name();
            this.timerange = source.timerange();
            this.query = source.query();
            this.streams = source.streams();
            this.type = source.type();
            this.id = source.id();
            this.filter = source.filter();
            this.filters = source.filters();
        }

        @Override
        public EventList.Builder name(@Nullable String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        public EventList.Builder timerange(@Nullable DerivedTimeRange timerange) {
            this.timerange = Optional.ofNullable(timerange);
            return this;
        }

        @Override
        public EventList.Builder query(@Nullable BackendQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @Override
        public EventList.Builder streams(Set<String> streams) {
            if (streams == null) {
                throw new NullPointerException("Null streams");
            }
            this.streams = streams;
            return this;
        }

        @Override
        public EventList.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public EventList.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nullable
        String id() {
            return this.id;
        }

        @Override
        public EventList.Builder filter(@Nullable Filter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public EventList.Builder filters(List<UsedSearchFilter> filters) {
            if (filters == null) {
                throw new NullPointerException("Null filters");
            }
            this.filters = filters;
            return this;
        }

        @Override
        EventList autoBuild() {
            if (this.streams == null || this.type == null || this.filters == null) {
                StringBuilder missing = new StringBuilder();
                if (this.streams == null) {
                    missing.append(" streams");
                }
                if (this.type == null) {
                    missing.append(" type");
                }
                if (this.filters == null) {
                    missing.append(" filters");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EventList(this.name, this.timerange, this.query, this.streams, this.type, this.id, this.filter, this.filters);
        }
    }
}

