/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.pivot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.views.search.searchtypes.Sort;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
public interface SortSpec {
    public static final String TYPE_FIELD = "type";
    public static final String FIELD_FIELD = "field";
    public static final String FIELD_DIRECTION = "direction";

    @JsonProperty(value="type")
    public String type();

    @JsonProperty(value="field")
    public String field();

    @JsonProperty(value="direction")
    public Direction direction();

    public static enum Direction {
        Ascending(Sort.Order.ASC),
        Descending(Sort.Order.DESC);

        @JsonIgnore
        private Sort.Order sortOrder;

        private Direction(Sort.Order sortOrder) {
            this.sortOrder = sortOrder;
        }

        @JsonCreator
        public static Direction deserialize(String value) {
            if (value == null || StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            return switch (value.trim().toLowerCase(Locale.ROOT)) {
                case "descending", "desc" -> Descending;
                case "ascending", "asc" -> Ascending;
                default -> throw new IllegalArgumentException("Failed to parse sort direction:" + value);
            };
        }

        @JsonIgnore
        public Sort.Order toSortOrder() {
            return this.sortOrder;
        }
    }
}

