/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.pivot.buckets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.AutoValue_AutoInterval;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.DateInterval;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Interval;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonTypeName(value="auto")
@AutoValue
public abstract class AutoInterval
implements Interval {
    private static final double CK_DEFAULT_SCALINGFACTOR = 1.0;
    private static final String FIELD_SCALING = "scaling";
    public static final String type = "auto";
    @VisibleForTesting
    static final ImmutableRangeMap<Duration, DateInterval> boundaries = ImmutableRangeMap.builder().put(Range.atMost((Comparable)Duration.ofMillis(20L)), (Object)new DateInterval(1, "ms")).put(Range.openClosed((Comparable)Duration.ofMillis(20L), (Comparable)Duration.ofMillis(200L)), (Object)new DateInterval(5, "ms")).put(Range.openClosed((Comparable)Duration.ofMillis(200L), (Comparable)Duration.ofMillis(500L)), (Object)new DateInterval(10, "ms")).put(Range.openClosed((Comparable)Duration.ofMillis(500L), (Comparable)Duration.ofMillis(1000L)), (Object)new DateInterval(20, "ms")).put(Range.openClosed((Comparable)Duration.ofMillis(1000L), (Comparable)Duration.ofSeconds(2L)), (Object)new DateInterval(40, "ms")).put(Range.openClosed((Comparable)Duration.ofSeconds(2L), (Comparable)Duration.ofSeconds(10L)), (Object)new DateInterval(200, "ms")).put(Range.openClosed((Comparable)Duration.ofSeconds(10L), (Comparable)Duration.ofSeconds(30L)), (Object)new DateInterval(500, "ms")).put(Range.openClosed((Comparable)Duration.ofSeconds(30L), (Comparable)Duration.ofMinutes(1L)), (Object)DateInterval.seconds(1)).put(Range.openClosed((Comparable)Duration.ofMinutes(1L), (Comparable)Duration.ofMinutes(2L)), (Object)DateInterval.seconds(2)).put(Range.openClosed((Comparable)Duration.ofMinutes(2L), (Comparable)Duration.ofMinutes(4L)), (Object)DateInterval.seconds(5)).put(Range.openClosed((Comparable)Duration.ofMinutes(4L), (Comparable)Duration.ofMinutes(7L)), (Object)DateInterval.seconds(10)).put(Range.openClosed((Comparable)Duration.ofMinutes(7L), (Comparable)Duration.ofMinutes(10L)), (Object)DateInterval.seconds(20)).put(Range.openClosed((Comparable)Duration.ofMinutes(10L), (Comparable)Duration.ofMinutes(30L)), (Object)DateInterval.seconds(30)).put(Range.openClosed((Comparable)Duration.ofMinutes(30L), (Comparable)Duration.ofHours(1L)), (Object)DateInterval.minutes(1)).put(Range.openClosed((Comparable)Duration.ofHours(1L), (Comparable)Duration.ofHours(2L)), (Object)DateInterval.minutes(2)).put(Range.openClosed((Comparable)Duration.ofHours(2L), (Comparable)Duration.ofHours(4L)), (Object)DateInterval.minutes(5)).put(Range.openClosed((Comparable)Duration.ofHours(4L), (Comparable)Duration.ofHours(12L)), (Object)DateInterval.minutes(10)).put(Range.openClosed((Comparable)Duration.ofHours(12L), (Comparable)Duration.ofHours(16L)), (Object)DateInterval.minutes(15)).put(Range.openClosed((Comparable)Duration.ofHours(16L), (Comparable)Duration.ofDays(1L)), (Object)DateInterval.minutes(30)).put(Range.openClosed((Comparable)Duration.ofDays(1L), (Comparable)Duration.ofDays(2L)), (Object)DateInterval.hours(1)).put(Range.openClosed((Comparable)Duration.ofDays(2L), (Comparable)Duration.ofDays(4L)), (Object)DateInterval.hours(2)).put(Range.openClosed((Comparable)Duration.ofDays(4L), (Comparable)Duration.ofDays(10L)), (Object)DateInterval.hours(4)).put(Range.openClosed((Comparable)Duration.ofDays(10L), (Comparable)Duration.ofDays(12L)), (Object)DateInterval.hours(6)).put(Range.openClosed((Comparable)Duration.ofDays(12L), (Comparable)Duration.ofDays(28L)), (Object)DateInterval.hours(12)).put(Range.openClosed((Comparable)Duration.ofDays(28L), (Comparable)Duration.ofDays(60L)), (Object)DateInterval.days(1)).put(Range.openClosed((Comparable)Duration.ofDays(60L), (Comparable)Duration.ofDays(120L)), (Object)DateInterval.days(2)).put(Range.openClosed((Comparable)Duration.ofDays(120L), (Comparable)Duration.ofDays(180L)), (Object)DateInterval.days(3)).put(Range.openClosed((Comparable)Duration.ofDays(180L), (Comparable)Duration.ofDays(365L)), (Object)DateInterval.weeks(1)).put(Range.open((Comparable)Duration.ofDays(365L), (Comparable)Duration.ofDays(730L)), (Object)DateInterval.days(14)).put(Range.atLeast((Comparable)Duration.ofDays(730L)), (Object)DateInterval.months(1)).build();

    @Override
    @JsonProperty
    public abstract String type();

    @JsonProperty
    public abstract Double scaling();

    @Override
    public DateInterval toDateInterval(TimeRange timerange) {
        Duration duration = Duration.ofMillis(Math.round(Double.valueOf(timerange.getTo().getMillis() - timerange.getFrom().getMillis()) / 1000.0 * this.scaling() * 1000.0));
        return (DateInterval)boundaries.get((Comparable)duration);
    }

    public static AutoInterval create() {
        return AutoInterval.create(type, 1.0);
    }

    public static AutoInterval create(double scalingFactor) {
        return new AutoValue_AutoInterval(type, scalingFactor);
    }

    @JsonCreator
    public static AutoInterval create(@JsonProperty(value="type") String type, @JsonProperty(value="scaling") @Nullable Double scalingFactor) {
        return AutoInterval.create(Optional.ofNullable(scalingFactor).orElse(1.0));
    }
}

