/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import com.google.auto.value.AutoValue;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.graylog.plugins.views.search.validation.AutoValue_ParsedTerm;
import org.graylog.plugins.views.search.validation.ImmutableToken;

@AutoValue
public abstract class ParsedTerm {
    public static final String DEFAULT_FIELD = "_default_";
    public static final String EXISTS = "_exists_";

    public abstract String field();

    public abstract String value();

    public abstract Optional<ImmutableToken> keyToken();

    public abstract Optional<ImmutableToken> valueToken();

    public static ParsedTerm create(String field, String value) {
        return ParsedTerm.builder().field(field).value(value).build();
    }

    public static ParsedTerm unknown(String term) {
        return ParsedTerm.builder().field(DEFAULT_FIELD).value(term).build();
    }

    public boolean isExistsField() {
        return this.field().equals(EXISTS);
    }

    public boolean isDefaultField() {
        return this.field().equals(DEFAULT_FIELD);
    }

    public String getRealFieldName() {
        if (this.isExistsField()) {
            return this.value();
        }
        return this.field();
    }

    public static Builder builder() {
        return new AutoValue_ParsedTerm.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder field(@NotNull String var1);

        public abstract Builder value(@NotNull String var1);

        public abstract Builder keyToken(@NotNull ImmutableToken var1);

        public abstract Builder valueToken(@NotNull ImmutableToken var1);

        public abstract ParsedTerm build();
    }
}

