/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.graylog.plugins.views.search.views.Infinity;
import org.graylog.plugins.views.search.views.NumberPosition;

public class Position {
    private static Position infinity() {
        return new Infinity();
    }

    public static Position fromInt(int value) {
        return new NumberPosition(value);
    }

    @JsonCreator
    public static Position fromJson(Object value) {
        if (value instanceof Number && !value.equals(Infinity.value)) {
            return Position.fromInt(((Number)value).intValue());
        }
        if (value instanceof Double && value.equals(Infinity.value)) {
            return Position.infinity();
        }
        if (value instanceof String && value.equals("Infinity")) {
            return Position.infinity();
        }
        throw new IllegalArgumentException("Unable to deserialize " + value + " to Position.");
    }
}

