/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.startpage.recentActivities;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.graylog.plugins.views.startpage.recentActivities.ActivityType;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityDTO;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityEvent;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityService;
import org.graylog.security.events.EntitySharesUpdateEvent;

public class RecentActivityUpdatesListener {
    private final RecentActivityService recentActivityService;

    @Inject
    public RecentActivityUpdatesListener(EventBus eventBus, RecentActivityService recentActivityService) {
        this.recentActivityService = recentActivityService;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void createUpdateRecentActivityFor(RecentActivityEvent event) {
        if (event.activityType().equals((Object)ActivityType.DELETE)) {
            this.recentActivityService.deleteAllEntriesForEntity(event.grn());
        }
        this.recentActivityService.save(RecentActivityDTO.builder().activityType(event.activityType()).itemGrn(event.grn()).itemTitle(event.itemTitle()).userName(event.userName()).build());
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    @Subscribe
    public void createRecentActivityFor(EntitySharesUpdateEvent event) {
        event.creates().stream().filter(this.distinctByKey(EntitySharesUpdateEvent.Share::grantee)).forEach(e -> this.recentActivityService.save(RecentActivityDTO.builder().activityType(ActivityType.SHARE).itemGrn(event.entity()).userName(event.user().getFullName()).grantee(e.grantee().toString()).build()));
        event.deletes().stream().filter(this.distinctByKey(EntitySharesUpdateEvent.Share::grantee)).forEach(e -> this.recentActivityService.save(RecentActivityDTO.builder().activityType(ActivityType.UNSHARE).itemGrn(event.entity()).userName(event.user().getFullName()).grantee(e.grantee().toString()).build()));
    }
}

