/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import one.util.streamex.StreamEx;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class DBJobDefinitionService
extends PaginatedDbService<JobDefinitionDto> {
    public static final String COLLECTION_NAME = "scheduler_job_definitions";
    private final ObjectMapper objectMapper;

    @Inject
    public DBJobDefinitionService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, JobDefinitionDto.class, COLLECTION_NAME);
        this.objectMapper = mapper.get();
    }

    public PaginatedList<JobDefinitionDto> getAllPaginated(String sortByField, int page, int perPage) {
        return this.findPaginatedWithQueryAndSort(DBQuery.empty(), DBSort.asc((String)sortByField), page, perPage);
    }

    public Optional<JobDefinitionDto> getByConfigField(String configField, Object value) {
        String field = String.format(Locale.US, "%s.%s", "config", configField);
        return Optional.ofNullable((JobDefinitionDto)this.db.findOne(DBQuery.is((String)field, (Object)value)));
    }

    public List<JobDefinitionDto> getByQuery(DBQuery.Query query) {
        return (List)StreamEx.of((Iterator)this.db.find(query)).collect(Collectors.toList());
    }

    public Map<String, List<JobDefinitionDto>> getAllByConfigField(String configField, Collection<? extends Object> values) {
        String field = String.format(Locale.US, "%s.%s", "config", configField);
        return StreamEx.of((Iterator)this.db.find(DBQuery.in((String)field, values))).groupingBy(this.configFieldGroup(configField));
    }

    private Function<JobDefinitionDto, String> configFieldGroup(String key) {
        return jobDefinition -> ((JsonNode)this.objectMapper.convertValue((Object)jobDefinition.config(), JsonNode.class)).path(key).asText();
    }
}

