/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graylog.scheduler.AutoValue_JobExecutionContext;
import org.graylog.scheduler.DBJobTriggerService;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.JobTriggerUpdates;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class JobExecutionContext {
    public abstract JobTriggerDto trigger();

    public abstract JobDefinitionDto definition();

    public abstract JobTriggerUpdates jobTriggerUpdates();

    public abstract AtomicBoolean schedulerIsRunning();

    public boolean isShuttingDown() {
        return !this.schedulerIsRunning().get();
    }

    public boolean isCancelled() {
        Optional<JobTriggerDto> triggerDto = this.jobTriggerService().get(this.trigger().id());
        return triggerDto.map(JobTriggerDto::isCancelled).orElse(false);
    }

    abstract DBJobTriggerService jobTriggerService();

    public void updateProgress(int progress) {
        this.jobTriggerService().updateProgress(this.trigger(), progress);
    }

    public static JobExecutionContext create(JobTriggerDto trigger, JobDefinitionDto definition, JobTriggerUpdates jobTriggerUpdates, AtomicBoolean schedulerIsRunning, DBJobTriggerService jobTriggerService) {
        return JobExecutionContext.builder().trigger(trigger).definition(definition).jobTriggerUpdates(jobTriggerUpdates).schedulerIsRunning(schedulerIsRunning).jobTriggerService(jobTriggerService).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_JobExecutionContext.Builder();
        }

        public abstract Builder trigger(JobTriggerDto var1);

        public abstract Builder definition(JobDefinitionDto var1);

        public abstract Builder jobTriggerUpdates(JobTriggerUpdates var1);

        public abstract Builder schedulerIsRunning(AtomicBoolean var1);

        public abstract Builder jobTriggerService(DBJobTriggerService var1);

        public abstract JobExecutionContext build();
    }
}

