/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler.rest;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.rest.JobResourceHandler;
import org.graylog.scheduler.rest.JobTriggerDetails;
import org.graylog.security.UserContext;
import org.graylog2.rest.models.system.SystemJobSummary;

public class JobResourceHandlerService {
    private final Map<String, JobResourceHandler> resourceHandlers;

    private Set<JobResourceHandler> allResourceHandlers() {
        return new HashSet<JobResourceHandler>(this.resourceHandlers.values().stream().collect(Collectors.toMap(r -> r.getClass().getName(), r -> r, (a, b) -> a)).values());
    }

    @Inject
    public JobResourceHandlerService(Map<String, JobResourceHandler> resourceHandlers) {
        this.resourceHandlers = resourceHandlers;
    }

    public List<JobTriggerDto> listJobs(UserContext userContext) {
        return this.allResourceHandlers().stream().flatMap(h -> h.listAllJobs(userContext).stream()).collect(Collectors.toList());
    }

    public List<SystemJobSummary> listJobsAsSystemJobSummary(UserContext userContext) {
        return this.listJobs(userContext).stream().map(this::jobSummaryFromTrigger).collect(Collectors.toList());
    }

    public Optional<JobTriggerDto> getJob(UserContext userContext, String jobId) {
        return this.allResourceHandlers().stream().map(h -> h.getJob(userContext, jobId)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<SystemJobSummary> getJobAsSystemJobSummery(UserContext userContext, String jobId) {
        return this.getJob(userContext, jobId).map(this::jobSummaryFromTrigger);
    }

    public Optional<JobTriggerDto> cancelJob(UserContext userContext, String jobId) {
        return this.allResourceHandlers().stream().map(h -> h.cancelJob(userContext, jobId)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<SystemJobSummary> cancelJobWithSystemJobSummary(UserContext userContext, String jobId) {
        return this.cancelJob(userContext, jobId).map(this::jobSummaryFromTrigger);
    }

    public int acknowledgeJob(UserContext userContext, String jobId) {
        return this.allResourceHandlers().stream().map(h -> h.acknowledgeJob(userContext, jobId)).reduce(0, Integer::sum);
    }

    public SystemJobSummary jobSummaryFromTrigger(JobTriggerDto trigger) {
        JobResourceHandler handler = this.resourceHandlers.get(trigger.jobDefinitionType());
        JobTriggerDetails details = handler == null ? JobTriggerDetails.EMPTY_DETAILS : handler.getTriggerDetails(trigger);
        return SystemJobSummary.create(trigger.id(), details.description(), details.systemJobName(), details.info(), Objects.toString(trigger.lock().lastOwner(), ""), trigger.triggeredAt().orElse(null), trigger.lock().progress(), details.isCancellable(), true, trigger.status());
    }
}

