/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.security.Capability;
import org.graylog.security.CapabilityDescriptor;

@Singleton
public class BuiltinCapabilities {
    private static ImmutableMap<Capability, CapabilityDescriptor> CAPABILITIES;

    @Inject
    public BuiltinCapabilities() {
        ImmutableSet readPermissions = ImmutableSet.of((Object)"streams:read", (Object)"stream_outputs:read", (Object)"dashboards:read", (Object)"view:read", (Object)"eventdefinitions:read", (Object)"eventnotifications:read", (Object[])new String[]{"outputs:read", "search_filters:read"});
        ImmutableSet editPermissions = ImmutableSet.of((Object)"streams:edit", (Object)"streams:changestate", (Object)"stream_outputs:create", (Object)"dashboards:edit", (Object)"view:edit", (Object)"eventdefinitions:edit", (Object[])new String[]{"eventnotifications:edit", "outputs:edit", "search_filters:edit"});
        ImmutableSet deletePermissions = ImmutableSet.of((Object)"stream_outputs:delete", (Object)"view:delete", (Object)"eventdefinitions:delete", (Object)"eventnotifications:delete", (Object)"outputs:terminate", (Object)"search_filters:delete", (Object[])new String[0]);
        CAPABILITIES = ImmutableMap.builder().put((Object)Capability.VIEW, (Object)CapabilityDescriptor.create(Capability.VIEW, "Viewer", (Set<String>)readPermissions)).put((Object)Capability.MANAGE, (Object)CapabilityDescriptor.create(Capability.MANAGE, "Manager", (Set<String>)ImmutableSet.builder().addAll((Iterable)readPermissions).addAll((Iterable)editPermissions).build())).put((Object)Capability.OWN, (Object)CapabilityDescriptor.create(Capability.OWN, "Owner", (Set<String>)ImmutableSet.builder().add((Object)"entity:own").addAll((Iterable)readPermissions).addAll((Iterable)editPermissions).addAll((Iterable)deletePermissions).build())).build();
    }

    public static ImmutableSet<CapabilityDescriptor> allSharingCapabilities() {
        return ImmutableSet.of((Object)((CapabilityDescriptor)CAPABILITIES.get((Object)Capability.VIEW)), (Object)((CapabilityDescriptor)CAPABILITIES.get((Object)Capability.MANAGE)), (Object)((CapabilityDescriptor)CAPABILITIES.get((Object)Capability.OWN)));
    }

    public Optional<CapabilityDescriptor> get(Capability capability) {
        return Optional.ofNullable((CapabilityDescriptor)CAPABILITIES.get((Object)capability));
    }
}

