/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.OptionalBinder;
import org.graylog.security.BuiltinCapabilities;
import org.graylog.security.DefaultPermissionAndRoleResolver;
import org.graylog.security.GranteeAuthorizer;
import org.graylog.security.PermissionAndRoleResolver;
import org.graylog.security.SecurityAuditEventTypes;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.InternalAuthServiceBackend;
import org.graylog.security.authservice.ProvisionerAction;
import org.graylog.security.authservice.backend.ADAuthServiceBackend;
import org.graylog.security.authservice.backend.ADAuthServiceBackendConfig;
import org.graylog.security.authservice.backend.LDAPAuthServiceBackend;
import org.graylog.security.authservice.backend.LDAPAuthServiceBackendConfig;
import org.graylog.security.authservice.backend.MongoDBAuthServiceBackend;
import org.graylog.security.authservice.ldap.UnboundLDAPConnector;
import org.graylog.security.authservice.rest.AuthServiceBackendsResource;
import org.graylog.security.authservice.rest.AuthServiceTestResource;
import org.graylog.security.authservice.rest.AuthServicesResource;
import org.graylog.security.authservice.rest.GlobalAuthServiceConfigResource;
import org.graylog.security.authservice.rest.HTTPHeaderAuthenticationConfigResource;
import org.graylog.security.authzroles.AuthzRolesResource;
import org.graylog.security.rest.EntitySharesResource;
import org.graylog.security.rest.GrantsOverviewResource;
import org.graylog.security.shares.DefaultGranteeService;
import org.graylog.security.shares.GranteeService;
import org.graylog2.plugin.PluginModule;

public class SecurityModule
extends PluginModule {
    protected void configure() {
        MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<ProvisionerAction.Factory<? extends ProvisionerAction>>(){});
        this.authServiceBackendBinder();
        this.bind(BuiltinCapabilities.class).asEagerSingleton();
        this.bind(UnboundLDAPConnector.class).in(Scopes.SINGLETON);
        this.install(new FactoryModuleBuilder().implement(GranteeAuthorizer.class, GranteeAuthorizer.class).build(GranteeAuthorizer.Factory.class));
        OptionalBinder.newOptionalBinder((Binder)this.binder(), PermissionAndRoleResolver.class).setDefault().to(DefaultPermissionAndRoleResolver.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), GranteeService.class).setDefault().to(DefaultGranteeService.class);
        this.bind(AuthServiceBackend.class).annotatedWith(InternalAuthServiceBackend.class).to(MongoDBAuthServiceBackend.class);
        this.addSystemRestResource(AuthServiceBackendsResource.class);
        this.addSystemRestResource(AuthServicesResource.class);
        this.addSystemRestResource(AuthServiceTestResource.class);
        this.addSystemRestResource(GlobalAuthServiceConfigResource.class);
        this.addSystemRestResource(HTTPHeaderAuthenticationConfigResource.class);
        this.addSystemRestResource(AuthzRolesResource.class);
        this.addSystemRestResource(EntitySharesResource.class);
        this.addSystemRestResource(GrantsOverviewResource.class);
        this.addAuditEventTypes(SecurityAuditEventTypes.class);
        this.addAuthServiceBackend("ldap", LDAPAuthServiceBackend.class, LDAPAuthServiceBackend.Factory.class, LDAPAuthServiceBackendConfig.class);
        this.addAuthServiceBackend("active-directory", ADAuthServiceBackend.class, ADAuthServiceBackend.Factory.class, ADAuthServiceBackendConfig.class);
    }
}

