/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.AuthServiceCredentials;
import org.graylog.security.authservice.AuthServiceToken;
import org.graylog.security.authservice.AuthenticationDetails;
import org.graylog.security.authservice.ProvisionerService;
import org.graylog.security.authservice.test.AuthServiceBackendTestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AuthServiceBackend {
    public static final Logger log = LoggerFactory.getLogger(AuthServiceBackend.class);
    public static final String INTERNAL_BACKEND_ID = "000000000000000000000001";

    default public Optional<AuthenticationDetails> authenticateAndProvision(AuthServiceCredentials authCredentials, ProvisionerService provisionerService) {
        log.debug("Cannot authenticate by username/password. Username/password authentication is not supported by auth service backend type <" + this.backendType() + ">.");
        return Optional.empty();
    }

    default public Optional<AuthenticationDetails> authenticateAndProvision(AuthServiceToken token, ProvisionerService provisionerService) {
        log.debug("Cannot authenticate by token. Token-based authentication is not supported by auth service backend type <" + this.backendTitle() + ">.");
        return Optional.empty();
    }

    public String backendType();

    public String backendId();

    public String backendTitle();

    public AuthServiceBackendDTO prepareConfigUpdate(AuthServiceBackendDTO var1, AuthServiceBackendDTO var2);

    public AuthServiceBackendTestResult testConnection(@Nullable AuthServiceBackendDTO var1);

    public AuthServiceBackendTestResult testLogin(AuthServiceCredentials var1, @Nullable AuthServiceBackendDTO var2);

    public static interface Factory<TYPE extends AuthServiceBackend> {
        public TYPE create(AuthServiceBackendDTO var1);
    }
}

