/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.nio.file.Path;
import java.util.List;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog.security.certutil.PathTypeConverterProvider;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.SystemConsole;
import org.graylog.security.certutil.csr.CsrGenerator;
import org.graylog.security.certutil.csr.storage.CsrFileStorage;
import org.graylog.security.certutil.csr.storage.CsrStorage;
import org.graylog.security.certutil.privatekey.PrivateKeyEncryptedFileStorage;
import org.graylog.security.certutil.privatekey.PrivateKeyEncryptedStorage;
import org.graylog2.bootstrap.CliCommand;

@Command(name="csr", description="Create CSR", groupNames={"certutil"})
public class CertutilCsr
implements CliCommand {
    @Option(name={"--privateKey"}, description="Keystore with private key", typeConverterProvider=PathTypeConverterProvider.class)
    protected Path privateKeyFilename = Path.of("csr-private-key.key", new String[0]);
    @Option(name={"--csrFile"}, description="Keystore with private key")
    protected String csrFilename = "csr.csr";
    private final CommandLineConsole console;
    private final PrivateKeyEncryptedStorage privateKeyEncryptedStorage;
    private final CsrStorage csrStorage;
    private final CsrGenerator csrGenerator;
    public static final CommandLineConsole.Prompt PROMPT_ENTER_PASSWORD_TO_PROTECT_YOUR_PRIVATE_KEY = CommandLineConsole.prompt("Enter password to protect your private key : ");

    public CertutilCsr() {
        this.console = new SystemConsole();
        this.privateKeyEncryptedStorage = new PrivateKeyEncryptedFileStorage(this.privateKeyFilename);
        this.csrStorage = new CsrFileStorage(this.csrFilename);
        this.csrGenerator = new CsrGenerator();
    }

    public CertutilCsr(Path privateKeyFilename, String csrFilename, CommandLineConsole console) {
        this.privateKeyFilename = privateKeyFilename;
        this.csrFilename = csrFilename;
        this.console = console;
        this.privateKeyEncryptedStorage = new PrivateKeyEncryptedFileStorage(privateKeyFilename);
        this.csrStorage = new CsrFileStorage(csrFilename);
        this.csrGenerator = new CsrGenerator();
    }

    @Override
    public void run() {
        this.console.printLine("This tool will generate a CSR for the datanode");
        char[] privKeyPassword = this.console.readPassword(PROMPT_ENTER_PASSWORD_TO_PROTECT_YOUR_PRIVATE_KEY);
        try {
            this.console.printLine("Generating CSR for the datanode");
            PKCS10CertificationRequest csr = this.csrGenerator.generateCSR(privKeyPassword, "localhost", List.of("data-node"), this.privateKeyEncryptedStorage);
            this.csrStorage.writeCsr(csr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

