/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.SystemConsole;
import org.graylog.security.certutil.csr.CsrSigner;
import org.graylog.security.certutil.csr.storage.CsrFileStorage;
import org.graylog.security.certutil.csr.storage.CsrStorage;
import org.graylog2.bootstrap.CliCommand;

@Command(name="csrsign", description="Signs a CSR using the given CA", groupNames={"certutil"})
public class CertutilCsrSign
implements CliCommand {
    @Option(name={"--ca"}, description="Filename for the CA keystore")
    protected String caKeystoreFilename = "datanode-ca.p12";
    @Option(name={"--csrFile"}, description="The CSR to sign")
    protected String csrFilename = "csr.csr";
    @Option(name={"--certFile"}, description="Filename for the signed certificate")
    protected String certFilename = "datanode-cert.p12";
    private final CommandLineConsole console;
    private final CsrStorage csrStorage;
    public static final CommandLineConsole.Prompt PROMPT_ENTER_CA_PASSWORD = CommandLineConsole.prompt("Enter CA password: ");
    public static final CommandLineConsole.Prompt PROMPT_ENTER_CERTIFICATE_VALIDITY_IN_DAYS = CommandLineConsole.prompt("Enter certificate validity in days: ");

    public CertutilCsrSign() {
        this.console = new SystemConsole();
        this.csrStorage = new CsrFileStorage(this.csrFilename);
    }

    public CertutilCsrSign(String caKeystoreFilename, String csrFilename, String certFilename, CommandLineConsole console) {
        this.caKeystoreFilename = caKeystoreFilename;
        this.certFilename = certFilename;
        this.csrStorage = new CsrFileStorage(csrFilename);
        this.console = console;
    }

    @Override
    public void run() {
        this.console.printLine("This tool will generate a data-node certificate for HTTP communication (REST API)");
        this.console.printLine("Generating a HTTP certificate signed by the datanode CA");
        Path caKeystorePath = Path.of(this.caKeystoreFilename, new String[0]);
        this.console.printLine("Using certificate authority " + caKeystorePath.toAbsolutePath());
        try {
            char[] password = this.console.readPassword(PROMPT_ENTER_CA_PASSWORD);
            KeyStore caKeystore = KeyStore.getInstance("PKCS12");
            caKeystore.load(new FileInputStream(this.caKeystoreFilename), password);
            PrivateKey caPrivateKey = (PrivateKey)caKeystore.getKey("ca", password);
            X509Certificate caCertificate = (X509Certificate)caKeystore.getCertificate("ca");
            PKCS10CertificationRequest csr = this.csrStorage.readCsr();
            int validityDays = this.console.readInt(PROMPT_ENTER_CERTIFICATE_VALIDITY_IN_DAYS);
            X509Certificate cert = new CsrSigner().sign(caPrivateKey, caCertificate, csr, validityDays);
            Path certPath = Path.of(this.certFilename, new String[0]);
            CertutilCsrSign.writePem(certPath, cert);
            this.console.printLine("Certificate written to file " + certPath.toAbsolutePath());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void writePem(Path path, Object object) throws IOException {
        FileWriter writer = new FileWriter(path.toFile(), StandardCharsets.UTF_8);
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        pemWriter.writeObject(object);
        pemWriter.flush();
        pemWriter.close();
    }
}

