/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.ca;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.time.Duration;
import org.graylog.security.certutil.CertRequest;
import org.graylog.security.certutil.CertificateGenerator;
import org.graylog.security.certutil.KeyPair;
import org.graylog.security.certutil.ca.exceptions.CACreationException;

public class CACreator {
    public KeyStore createCA(char[] password, Duration certificateValidity) throws CACreationException {
        try {
            KeyPair rootCA = CertificateGenerator.generate(CertRequest.selfSigned("root").isCA(true).validity(certificateValidity));
            KeyPair intermediateCA = CertificateGenerator.generate(CertRequest.signed("ca", rootCA).isCA(true).validity(certificateValidity));
            KeyStore caKeystore = KeyStore.getInstance("PKCS12");
            caKeystore.load(null, null);
            caKeystore.setKeyEntry("root", rootCA.privateKey(), password, new X509Certificate[]{rootCA.certificate()});
            caKeystore.setKeyEntry("ca", intermediateCA.privateKey(), password, new X509Certificate[]{intermediateCA.certificate(), rootCA.certificate()});
            return caKeystore;
        }
        catch (Exception e) {
            throw new CACreationException("Failed to create a Certificate Authority", e);
        }
    }
}

