/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.ca;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.graylog.security.certutil.ca.exceptions.CACreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PemCaReader {
    private static final Logger LOG = LoggerFactory.getLogger(PemCaReader.class);
    static final String PADDING = "-----";
    static final String BEGIN = "-----BEGIN";
    static final String END = "-----END";

    X509Certificate readCert(String cert) throws IOException, CertificateException {
        StringReader pemReader = new StringReader(cert);
        PEMParser pemParser = new PEMParser((Reader)pemReader);
        Object parsedObj = pemParser.readObject();
        if (parsedObj instanceof X509Certificate) {
            return (X509Certificate)parsedObj;
        }
        if (parsedObj instanceof X509CertificateHolder) {
            return new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)parsedObj);
        }
        return null;
    }

    Optional<RSAPrivateKey> readPrivateKey(String key, char[] password) {
        try {
            StringReader reader = new StringReader(key);
            PEMParser pemParser = new PEMParser((Reader)reader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object object = pemParser.readObject();
            if (object instanceof PEMEncryptedKeyPair) {
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password);
                return Optional.of((RSAPrivateKey)converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv)).getPrivate());
            }
            return Optional.of((RSAPrivateKey)converter.getKeyPair((PEMKeyPair)object).getPrivate());
        }
        catch (Exception ex) {
            LOG.error("Could not decode private key from pem: " + ex.getMessage(), (Throwable)ex);
            return Optional.empty();
        }
    }

    List<String> splitPem(String pem) {
        ArrayList<String> parts = new ArrayList<String>();
        while (pem.contains(BEGIN) && pem.contains(END)) {
            int start = pem.indexOf(BEGIN);
            int end = pem.indexOf(PADDING, pem.indexOf(END) + END.length()) + PADDING.length();
            parts.add(pem.substring(start, end));
            pem = pem.substring(end);
        }
        return parts;
    }

    Optional<String> findCert(List<String> certs, String type) {
        return certs.stream().filter(c -> c.startsWith(type)).findFirst();
    }

    void addCert(KeyStore keyStore, char[] password, RSAPrivateKey pk, String cert, String name) {
        try {
            X509Certificate certificate = this.readCert(cert);
            keyStore.setKeyEntry(name, pk, password, new X509Certificate[]{certificate});
        }
        catch (Exception e) {
            LOG.error("Could not find certificate: " + e.getMessage(), (Throwable)e);
        }
    }

    public KeyStore readCA(KeyStore keyStore, char[] password, String pem) throws CACreationException {
        try {
            List<String> certs = this.splitPem(pem);
            RSAPrivateKey pk = (RSAPrivateKey)this.findCert(certs, "-----BEGIN RSA PRIVATE KEY").flatMap(c -> this.readPrivateKey((String)c, password)).orElseThrow();
            certs.remove(this.findCert(certs, "-----BEGIN RSA PRIVATE KEY").orElse(null));
            Optional<String> root = this.findCert(certs, "-----BEGIN CERTIFICATE");
            root.ifPresent(cert -> {
                this.addCert(keyStore, password, pk, (String)cert, "root");
                certs.remove(cert);
            });
            Optional<String> ca = this.findCert(certs, "-----BEGIN CERTIFICATE");
            ca.ifPresent(cert -> {
                this.addCert(keyStore, password, pk, (String)cert, "ca");
                certs.remove(cert);
            });
            return keyStore;
        }
        catch (Exception e) {
            throw new CACreationException("Failed to create a Certificate Authority", e);
        }
    }
}

