/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.cert.storage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.Optional;
import javax.inject.Inject;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.graylog.security.certutil.cert.CertificateChain;
import org.graylog.security.certutil.cert.storage.CertChainStorage;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;

public class CertChainMongoStorage
implements CertChainStorage {
    private DataNodeProvisioningService mongoService;

    @Inject
    public CertChainMongoStorage(DataNodeProvisioningService mongoService) {
        this.mongoService = mongoService;
    }

    @Override
    public void writeCertChain(CertificateChain certChain, String nodeId) throws IOException, OperatorCreationException {
        StringWriter writer = new StringWriter();
        try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)writer);){
            for (Certificate cert : certChain.toCertificateChainArray()) {
                jcaPEMWriter.writeObject((Object)cert);
            }
        }
        this.mongoService.writeCert(nodeId, writer.toString());
    }

    @Override
    public Optional<CertificateChain> readCertChain(String nodeId) throws IOException, GeneralSecurityException {
        Optional<String> certAsString = this.mongoService.readCert(nodeId);
        if (certAsString.isPresent()) {
            BufferedReader pemReader = new BufferedReader(new StringReader(certAsString.get()));
            PEMParser pemParser = new PEMParser((Reader)pemReader);
            LinkedList<X509Certificate> caCerts = new LinkedList<X509Certificate>();
            X509Certificate signedCert = this.readSingleCert(pemParser);
            if (signedCert != null) {
                X509Certificate caCert = this.readSingleCert(pemParser);
                while (caCert != null) {
                    caCerts.add(caCert);
                    caCert = this.readSingleCert(pemParser);
                }
                return Optional.of(new CertificateChain(signedCert, caCerts));
            }
        }
        return Optional.empty();
    }

    private X509Certificate readSingleCert(PEMParser pemParser) throws IOException, CertificateException {
        Object parsedObj = pemParser.readObject();
        if (parsedObj instanceof X509Certificate) {
            return (X509Certificate)parsedObj;
        }
        if (parsedObj instanceof X509CertificateHolder) {
            return new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)parsedObj);
        }
        return null;
    }
}

