/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.csr;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import javax.inject.Inject;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCSException;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog.security.certutil.cert.CertificateChain;
import org.graylog.security.certutil.csr.KeyPairChecker;
import org.graylog.security.certutil.privatekey.PrivateKeyEncryptedStorage;

public class CertificateAndPrivateKeyMerger {
    private final KeyPairChecker keyPairChecker;

    @Inject
    public CertificateAndPrivateKeyMerger(KeyPairChecker keyPairChecker) {
        this.keyPairChecker = keyPairChecker;
    }

    public KeyStore merge(CertificateChain certificateChain, PrivateKeyEncryptedStorage privateKeyEncryptedStorage, char[] privateKeyStoragePassword, char[] certFilePassword, String alias) throws GeneralSecurityException, IOException, OperatorCreationException, PKCSException, KeyStoreStorageException {
        KeyStore nodeKeystore = KeyStore.getInstance("PKCS12");
        nodeKeystore.load(null, null);
        PrivateKey privateKey = privateKeyEncryptedStorage.readEncryptedKey(privateKeyStoragePassword);
        if (!this.keyPairChecker.matchingKeys(privateKey, certificateChain.signedCertificate().getPublicKey())) {
            throw new GeneralSecurityException("Private key from CSR and public key from certificate do not form a valid pair");
        }
        nodeKeystore.setKeyEntry(alias, privateKey, certFilePassword, certificateChain.toCertificateChainArray());
        return nodeKeystore;
    }
}

