/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.csr;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.graylog.security.certutil.csr.exceptions.CSRGenerationException;
import org.graylog.security.certutil.privatekey.PrivateKeyEncryptedStorage;

public class CsrGenerator {
    public PKCS10CertificationRequest generateCSR(char[] privateKeyPassword, String principalName, List<String> altNames, PrivateKeyEncryptedStorage privateKeyEncryptedStorage) throws CSRGenerationException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            KeyPair certKeyPair = keyGen.generateKeyPair();
            privateKeyEncryptedStorage.writeEncryptedKey(privateKeyPassword, certKeyPair.getPrivate());
            JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(new X500Principal("CN=" + principalName), certKeyPair.getPublic());
            ArrayList<String> names = new ArrayList<String>(List.of(principalName));
            if (altNames != null) {
                names.addAll(altNames);
            }
            Extension subjectAltNames = new Extension(Extension.subjectAlternativeName, false, (ASN1OctetString)new DEROctetString((ASN1Encodable)new GeneralNames((GeneralName[])names.stream().map(alternativeName -> new GeneralName(2, alternativeName)).toArray(GeneralName[]::new))));
            p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)new Extensions(subjectAltNames));
            JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder("SHA256withRSA");
            ContentSigner signer = csBuilder.build(certKeyPair.getPrivate());
            return p10Builder.build(signer);
        }
        catch (Exception e) {
            throw new CSRGenerationException("Failed to generate Certificate Signing Request", e);
        }
    }
}

