/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.entities;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;
import org.graylog.security.Capability;
import org.graylog.security.DBGrantService;
import org.graylog.security.GrantDTO;
import org.graylog2.plugin.database.users.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EntityOwnershipService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityOwnershipService.class);
    private final DBGrantService dbGrantService;
    private final GRNRegistry grnRegistry;

    @Inject
    public EntityOwnershipService(DBGrantService dbGrantService, GRNRegistry grnRegistry) {
        this.dbGrantService = dbGrantService;
        this.grnRegistry = grnRegistry;
    }

    public void registerNewEventDefinition(String id, User user) {
        GRN grn = this.grnRegistry.newGRN(GRNTypes.EVENT_DEFINITION, id);
        this.registerNewEntity(grn, user);
    }

    public void registerNewEventNotification(String id, User user) {
        GRN grn = this.grnRegistry.newGRN(GRNTypes.EVENT_NOTIFICATION, id);
        this.registerNewEntity(grn, user);
    }

    public void registerNewDashboard(String id, User user) {
        GRN grn = this.grnRegistry.newGRN(GRNTypes.DASHBOARD, id);
        this.registerNewEntity(grn, user);
    }

    public void registerNewSearch(String id, User user) {
        GRN grn = this.grnRegistry.newGRN(GRNTypes.SEARCH, id);
        this.registerNewEntity(grn, user);
    }

    public void registerNewStream(String id, User user) {
        GRN grn = this.grnRegistry.newGRN(GRNTypes.STREAM, id);
        this.registerNewEntity(grn, user);
    }

    public void registerNewEntity(String id, User user, GRNType grnType) {
        GRN grn = this.grnRegistry.newGRN(grnType, id);
        this.registerNewEntity(grn, user);
    }

    public void unregisterEntity(String id, GRNType grnType) {
        this.removeGrantsForTarget(this.grnRegistry.newGRN(grnType, id));
    }

    private void registerNewEntity(GRN entity, User user) {
        if (user.isLocalAdmin()) {
            return;
        }
        this.dbGrantService.create(GrantDTO.builder().capability(Capability.OWN).target(entity).grantee(this.grnRegistry.ofUser(user)).build(), user);
    }

    public void unregisterStream(String id) {
        this.removeGrantsForTarget(this.grnRegistry.newGRN(GRNTypes.STREAM, id));
    }

    public void unregisterDashboard(String id) {
        this.removeGrantsForTarget(this.grnRegistry.newGRN(GRNTypes.DASHBOARD, id));
    }

    public void unregisterSearch(String id) {
        this.removeGrantsForTarget(this.grnRegistry.newGRN(GRNTypes.SEARCH, id));
    }

    public void unregisterEventDefinition(String id) {
        this.removeGrantsForTarget(this.grnRegistry.newGRN(GRNTypes.EVENT_DEFINITION, id));
    }

    public void unregisterEventNotification(String id) {
        this.removeGrantsForTarget(this.grnRegistry.newGRN(GRNTypes.EVENT_NOTIFICATION, id));
    }

    private void removeGrantsForTarget(GRN target) {
        LOG.debug("Removing grants for <{}>", (Object)target);
        this.dbGrantService.deleteForTarget(target);
    }
}

