/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.shares;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.graylog.grn.GRN;
import org.graylog.security.Capability;
import org.graylog.security.entities.EntityDescriptor;
import org.graylog.security.shares.EntityShareResponse;
import org.graylog.security.shares.Grantee;
import org.graylog2.plugin.rest.ValidationResult;

final class AutoValue_EntityShareResponse
extends EntityShareResponse {
    private final String entity;
    private final GRN sharingUser;
    private final ImmutableSet<Grantee> availableGrantees;
    private final ImmutableSet<EntityShareResponse.AvailableCapability> availableCapabilities;
    private final ImmutableSet<EntityShareResponse.ActiveShare> activeShares;
    private final ImmutableMap<GRN, Capability> selectedGranteeCapabilities;
    private final ImmutableMap<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies;
    private final ValidationResult validationResult;

    private AutoValue_EntityShareResponse(String entity, GRN sharingUser, ImmutableSet<Grantee> availableGrantees, ImmutableSet<EntityShareResponse.AvailableCapability> availableCapabilities, ImmutableSet<EntityShareResponse.ActiveShare> activeShares, ImmutableMap<GRN, Capability> selectedGranteeCapabilities, ImmutableMap<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies, ValidationResult validationResult) {
        this.entity = entity;
        this.sharingUser = sharingUser;
        this.availableGrantees = availableGrantees;
        this.availableCapabilities = availableCapabilities;
        this.activeShares = activeShares;
        this.selectedGranteeCapabilities = selectedGranteeCapabilities;
        this.missingPermissionsOnDependencies = missingPermissionsOnDependencies;
        this.validationResult = validationResult;
    }

    @Override
    @JsonProperty(value="entity")
    public String entity() {
        return this.entity;
    }

    @Override
    @JsonProperty(value="sharing_user")
    public GRN sharingUser() {
        return this.sharingUser;
    }

    @Override
    @JsonProperty(value="available_grantees")
    public ImmutableSet<Grantee> availableGrantees() {
        return this.availableGrantees;
    }

    @Override
    @JsonProperty(value="available_capabilities")
    public ImmutableSet<EntityShareResponse.AvailableCapability> availableCapabilities() {
        return this.availableCapabilities;
    }

    @Override
    @JsonProperty(value="active_shares")
    public ImmutableSet<EntityShareResponse.ActiveShare> activeShares() {
        return this.activeShares;
    }

    @Override
    @JsonProperty(value="selected_grantee_capabilities")
    public ImmutableMap<GRN, Capability> selectedGranteeCapabilities() {
        return this.selectedGranteeCapabilities;
    }

    @Override
    @JsonProperty(value="missing_permissions_on_dependencies")
    public ImmutableMap<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies() {
        return this.missingPermissionsOnDependencies;
    }

    @Override
    @JsonProperty(value="validation_result")
    public ValidationResult validationResult() {
        return this.validationResult;
    }

    public String toString() {
        return "EntityShareResponse{entity=" + this.entity + ", sharingUser=" + this.sharingUser + ", availableGrantees=" + this.availableGrantees + ", availableCapabilities=" + this.availableCapabilities + ", activeShares=" + this.activeShares + ", selectedGranteeCapabilities=" + this.selectedGranteeCapabilities + ", missingPermissionsOnDependencies=" + this.missingPermissionsOnDependencies + ", validationResult=" + this.validationResult + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EntityShareResponse) {
            EntityShareResponse that = (EntityShareResponse)o;
            return this.entity.equals(that.entity()) && this.sharingUser.equals(that.sharingUser()) && this.availableGrantees.equals(that.availableGrantees()) && this.availableCapabilities.equals(that.availableCapabilities()) && this.activeShares.equals(that.activeShares()) && this.selectedGranteeCapabilities.equals(that.selectedGranteeCapabilities()) && this.missingPermissionsOnDependencies.equals(that.missingPermissionsOnDependencies()) && this.validationResult.equals(that.validationResult());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.entity.hashCode();
        h$ *= 1000003;
        h$ ^= this.sharingUser.hashCode();
        h$ *= 1000003;
        h$ ^= this.availableGrantees.hashCode();
        h$ *= 1000003;
        h$ ^= this.availableCapabilities.hashCode();
        h$ *= 1000003;
        h$ ^= this.activeShares.hashCode();
        h$ *= 1000003;
        h$ ^= this.selectedGranteeCapabilities.hashCode();
        h$ *= 1000003;
        h$ ^= this.missingPermissionsOnDependencies.hashCode();
        h$ *= 1000003;
        return h$ ^= this.validationResult.hashCode();
    }

    static final class Builder
    extends EntityShareResponse.Builder {
        private String entity;
        private GRN sharingUser;
        private ImmutableSet<Grantee> availableGrantees;
        private ImmutableSet<EntityShareResponse.AvailableCapability> availableCapabilities;
        private ImmutableSet<EntityShareResponse.ActiveShare> activeShares;
        private ImmutableMap<GRN, Capability> selectedGranteeCapabilities;
        private ImmutableMap<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies;
        private ValidationResult validationResult;

        Builder() {
        }

        @Override
        public EntityShareResponse.Builder entity(String entity) {
            if (entity == null) {
                throw new NullPointerException("Null entity");
            }
            this.entity = entity;
            return this;
        }

        @Override
        public EntityShareResponse.Builder sharingUser(GRN sharingUser) {
            if (sharingUser == null) {
                throw new NullPointerException("Null sharingUser");
            }
            this.sharingUser = sharingUser;
            return this;
        }

        @Override
        public EntityShareResponse.Builder availableGrantees(Set<Grantee> availableGrantees) {
            this.availableGrantees = ImmutableSet.copyOf(availableGrantees);
            return this;
        }

        @Override
        public EntityShareResponse.Builder availableCapabilities(Set<EntityShareResponse.AvailableCapability> availableCapabilities) {
            this.availableCapabilities = ImmutableSet.copyOf(availableCapabilities);
            return this;
        }

        @Override
        public EntityShareResponse.Builder activeShares(Set<EntityShareResponse.ActiveShare> activeShares) {
            this.activeShares = ImmutableSet.copyOf(activeShares);
            return this;
        }

        @Override
        public EntityShareResponse.Builder selectedGranteeCapabilities(Map<GRN, Capability> selectedGranteeCapabilities) {
            this.selectedGranteeCapabilities = ImmutableMap.copyOf(selectedGranteeCapabilities);
            return this;
        }

        @Override
        public EntityShareResponse.Builder missingPermissionsOnDependencies(Map<GRN, Collection<EntityDescriptor>> missingPermissionsOnDependencies) {
            this.missingPermissionsOnDependencies = ImmutableMap.copyOf(missingPermissionsOnDependencies);
            return this;
        }

        @Override
        public EntityShareResponse.Builder validationResult(ValidationResult validationResult) {
            if (validationResult == null) {
                throw new NullPointerException("Null validationResult");
            }
            this.validationResult = validationResult;
            return this;
        }

        @Override
        public EntityShareResponse build() {
            if (this.entity == null || this.sharingUser == null || this.availableGrantees == null || this.availableCapabilities == null || this.activeShares == null || this.selectedGranteeCapabilities == null || this.missingPermissionsOnDependencies == null || this.validationResult == null) {
                StringBuilder missing = new StringBuilder();
                if (this.entity == null) {
                    missing.append(" entity");
                }
                if (this.sharingUser == null) {
                    missing.append(" sharingUser");
                }
                if (this.availableGrantees == null) {
                    missing.append(" availableGrantees");
                }
                if (this.availableCapabilities == null) {
                    missing.append(" availableCapabilities");
                }
                if (this.activeShares == null) {
                    missing.append(" activeShares");
                }
                if (this.selectedGranteeCapabilities == null) {
                    missing.append(" selectedGranteeCapabilities");
                }
                if (this.missingPermissionsOnDependencies == null) {
                    missing.append(" missingPermissionsOnDependencies");
                }
                if (this.validationResult == null) {
                    missing.append(" validationResult");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EntityShareResponse(this.entity, this.sharingUser, this.availableGrantees, this.availableCapabilities, this.activeShares, this.selectedGranteeCapabilities, this.missingPermissionsOnDependencies, this.validationResult);
        }
    }
}

