/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog.security.certutil.CaConfiguration;
import org.graylog.security.certutil.CaService;
import org.graylog.security.certutil.cert.CertificateChain;
import org.graylog.security.certutil.cert.storage.CertChainMongoStorage;
import org.graylog.security.certutil.cert.storage.CertChainStorage;
import org.graylog.security.certutil.csr.CsrSigner;
import org.graylog.security.certutil.csr.storage.CsrMongoStorage;
import org.graylog2.Configuration;
import org.graylog2.bootstrap.preflight.PreflightConfig;
import org.graylog2.bootstrap.preflight.PreflightConfigResult;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.security.CustomCAX509TrustManager;
import org.graylog2.security.IndexerJwtAuthTokenProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GraylogCertificateProvisioningPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(GraylogCertificateProvisioningPeriodical.class);
    private final DataNodeProvisioningService dataNodeProvisioningService;
    private final NodeService nodeService;
    private final CaConfiguration configuration;
    private final CsrMongoStorage csrStorage;
    private final CertChainStorage certMongoStorage;
    private final CaService caService;
    private final CsrSigner csrSigner;
    private final ClusterConfigService clusterConfigService;
    private final String passwordSecret;
    private final EventBus serverEventBus;
    private Optional<OkHttpClient> okHttpClient = Optional.empty();
    private final PreflightConfigService preflightConfigService;
    private final IndexerJwtAuthTokenProvider indexerJwtAuthTokenProvider;
    private final NotificationService notificationService;

    @Inject
    public GraylogCertificateProvisioningPeriodical(DataNodeProvisioningService dataNodeProvisioningService, CsrMongoStorage csrStorage, CertChainMongoStorage certMongoStorage, CaService caService, Configuration configuration, NodeService nodeService, CsrSigner csrSigner, ClusterConfigService clusterConfigService, @Named(value="password_secret") String passwordSecret, IndexerJwtAuthTokenProvider indexerJwtAuthTokenProvider, PreflightConfigService preflightConfigService, EventBus serverEventBus, NotificationService notificationService) {
        this.dataNodeProvisioningService = dataNodeProvisioningService;
        this.csrStorage = csrStorage;
        this.certMongoStorage = certMongoStorage;
        this.caService = caService;
        this.passwordSecret = passwordSecret;
        this.configuration = configuration;
        this.nodeService = nodeService;
        this.csrSigner = csrSigner;
        this.clusterConfigService = clusterConfigService;
        this.serverEventBus = serverEventBus;
        this.preflightConfigService = preflightConfigService;
        this.indexerJwtAuthTokenProvider = indexerJwtAuthTokenProvider;
        this.notificationService = notificationService;
    }

    private Optional<OkHttpClient> buildConnectivityCheckOkHttpClient() {
        try {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                CustomCAX509TrustManager tm = new CustomCAX509TrustManager(this.caService, this.serverEventBus);
                sslContext.init(null, new TrustManager[]{tm}, new SecureRandom());
                clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)tm);
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.error("Could not set Graylog CA trustmanager: {}", (Object)ex.getMessage(), (Object)ex);
            }
            return Optional.of(clientBuilder.build());
        }
        catch (Exception ex) {
            LOG.error("Could not create temporary okhttpclient " + ex.getMessage(), (Throwable)ex);
            return Optional.empty();
        }
    }

    private RenewalPolicy getRenewalPolicy() {
        return this.clusterConfigService.get(RenewalPolicy.class);
    }

    @Override
    public void doRun() {
        LOG.debug("checking if there are configuration steps to take care of");
        try {
            List<DataNodeProvisioningConfig> nodes = this.dataNodeProvisioningService.findAllNodesThatNeedAttention();
            if (!nodes.isEmpty()) {
                char[] password = this.configuration.configuredCaExists() ? this.configuration.getCaPassword().toCharArray() : this.passwordSecret.toCharArray();
                Optional<KeyStore> optKey = this.caService.loadKeyStore();
                if (optKey.isEmpty()) {
                    LOG.debug("No keystore available.");
                    return;
                }
                RenewalPolicy renewalPolicy = this.getRenewalPolicy();
                if (renewalPolicy == null) {
                    LOG.debug("No renewal policy available.");
                    return;
                }
                if (this.okHttpClient.isEmpty()) {
                    this.okHttpClient = this.buildConnectivityCheckOkHttpClient();
                }
                KeyStore caKeystore = optKey.get();
                PrivateKey caPrivateKey = (PrivateKey)caKeystore.getKey("ca", password);
                X509Certificate caCertificate = (X509Certificate)caKeystore.getCertificate("ca");
                X509Certificate rootCertificate = (X509Certificate)caKeystore.getCertificate("root");
                Optional<PreflightConfig> preflightConfig = this.preflightConfigService.getPersistedConfig();
                preflightConfig.ifPresent(cfg -> {
                    if (cfg.result().equals((Object)PreflightConfigResult.FINISHED)) {
                        if (renewalPolicy.mode().equals((Object)RenewalPolicy.Mode.AUTOMATIC)) {
                            nodes.stream().filter(c -> DataNodeProvisioningConfig.State.UNCONFIGURED.equals((Object)c.state())).forEach(c -> this.dataNodeProvisioningService.save(c.toBuilder().state(DataNodeProvisioningConfig.State.CONFIGURED).build()));
                        } else {
                            Optional<DataNodeProvisioningConfig> hasUnconfiguredNodes = nodes.stream().filter(c -> DataNodeProvisioningConfig.State.UNCONFIGURED.equals((Object)c.state())).findFirst();
                            if (hasUnconfiguredNodes.isPresent()) {
                                Notification notification = this.notificationService.buildNow().addType(Notification.Type.DATA_NODE_NEEDS_PROVISIONING).addSeverity(Notification.Severity.URGENT);
                                this.notificationService.publishIfFirst(notification);
                            } else {
                                this.notificationService.fixed(Notification.Type.DATA_NODE_NEEDS_PROVISIONING);
                            }
                        }
                    }
                });
                nodes.stream().filter(c -> DataNodeProvisioningConfig.State.CSR.equals((Object)c.state())).forEach(c -> {
                    try {
                        Optional<PKCS10CertificationRequest> csr = this.csrStorage.readCsr(c.nodeId());
                        if (csr.isEmpty()) {
                            LOG.error("Node in CSR state, but no CSR present : " + c.nodeId());
                            this.dataNodeProvisioningService.save(c.toBuilder().state(DataNodeProvisioningConfig.State.ERROR).errorMsg("Node in CSR state, but no CSR present").build());
                        } else {
                            X509Certificate cert = this.csrSigner.sign(caPrivateKey, caCertificate, csr.get(), renewalPolicy);
                            List<X509Certificate> caCertificates = List.of(caCertificate, rootCertificate);
                            this.certMongoStorage.writeCertChain(new CertificateChain(cert, caCertificates), c.nodeId());
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Could not sign CSR: " + e.getMessage(), (Throwable)e);
                        this.dataNodeProvisioningService.save(c.toBuilder().state(DataNodeProvisioningConfig.State.ERROR).errorMsg(e.getMessage()).build());
                    }
                });
                nodes.stream().filter(c -> DataNodeProvisioningConfig.State.STORED.equals((Object)c.state())).forEach(c -> {
                    try {
                        if (this.checkConnectivity(c.nodeId())) {
                            this.dataNodeProvisioningService.save(c.toBuilder().state(DataNodeProvisioningConfig.State.CONNECTED).build());
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Exception trying to connect to node " + c.nodeId() + ": " + e.getMessage() + ", retrying", (Throwable)e);
                    }
                });
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkConnectivity(String nodeId) throws NodeNotFoundException, IOException {
        Node node = this.nodeService.byNodeId(nodeId);
        Request request = new Request.Builder().url(node.getTransportAddress()).build();
        if (this.okHttpClient.isPresent()) {
            OkHttpClient.Builder builder = this.okHttpClient.get().newBuilder();
            builder.authenticator((route, response) -> response.request().newBuilder().header("Authorization", this.indexerJwtAuthTokenProvider.get()).build());
            Call call = builder.build().newCall(request);
            try (Response response2 = call.execute();){
                boolean bl = response2.isSuccessful();
                return bl;
            }
        }
        return false;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 2;
    }

    @Override
    public int getPeriodSeconds() {
        return 2;
    }
}

