/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.github.zafarkhaja.semver.Version;
import com.mongodb.MongoClient;
import com.mongodb.MongoTimeoutException;
import com.mongodb.client.model.Filters;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.bootstrap.preflight.PreflightCheck;
import org.graylog2.bootstrap.preflight.PreflightCheckException;
import org.graylog2.configuration.MongoDbConfiguration;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.MongoConnectionImpl;
import org.graylog2.database.MongoDBVersionCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBPreflightCheck
implements PreflightCheck {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBPreflightCheck.class);
    private static final String CLUSTER_CONFIG_COLLECTION_NAME = "cluster_config";
    private final int mongoVersionProbeAttempts;
    private final MongoConnection mongoConnection;
    private final AtomicBoolean isFreshInstallation;

    @Inject
    public MongoDBPreflightCheck(@Named(value="mongodb_version_probe_attempts") int mongoVersionProbeAttempts, MongoDbConfiguration configuration) {
        this.mongoVersionProbeAttempts = mongoVersionProbeAttempts;
        this.mongoConnection = new MongoConnectionImpl(configuration);
        this.isFreshInstallation = new AtomicBoolean(false);
    }

    public boolean isFreshInstallation() {
        return this.isFreshInstallation.get();
    }

    @Override
    public void runCheck() throws PreflightCheckException {
        try {
            Version mongoVersion = (Version)RetryerBuilder.newBuilder().retryIfResult(Objects::isNull).retryIfExceptionOfType(MongoTimeoutException.class).retryIfRuntimeException().withRetryListener(new RetryListener(){

                public <V> void onRetry(Attempt<V> attempt) {
                    if (attempt.hasResult()) {
                        return;
                    }
                    if (MongoDBPreflightCheck.this.mongoVersionProbeAttempts == 0) {
                        LOG.info("MongoDB is not available. Retry #{}", (Object)attempt.getAttemptNumber());
                    } else {
                        LOG.info("MongoDB is not available. Retry #{}/{}", (Object)attempt.getAttemptNumber(), (Object)MongoDBPreflightCheck.this.mongoVersionProbeAttempts);
                    }
                }
            }).withWaitStrategy(WaitStrategies.fixedWait((long)2L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(this.mongoVersionProbeAttempts == 0 ? StopStrategies.neverStop() : StopStrategies.stopAfterAttempt((int)this.mongoVersionProbeAttempts)).build().call(() -> {
                try (MongoClient mongoClient = this.mongoConnection.connect();){
                    this.detectFreshInstallation();
                    Version version = MongoDBVersionCheck.getVersion(mongoClient);
                    return version;
                }
            });
            MongoDBVersionCheck.assertCompatibleVersion(mongoVersion);
            LOG.info("Connected to MongoDB version {}", (Object)mongoVersion);
        }
        catch (RetryException | ExecutionException e) {
            throw new PreflightCheckException("Failed to retrieve MongoDB version.", e);
        }
    }

    private void detectFreshInstallation() {
        boolean collectionExists = ((HashSet)this.mongoConnection.getMongoDatabase().listCollectionNames().into(new HashSet())).contains(CLUSTER_CONFIG_COLLECTION_NAME);
        boolean configurationExists = collectionExists && this.mongoConnection.getMongoDatabase().getCollection(CLUSTER_CONFIG_COLLECTION_NAME).find(Filters.eq((String)"type", (Object)"org.graylog2.plugin.cluster.ClusterId")).first() != null;
        this.isFreshInstallation.set(!configurationExists);
    }
}

