/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.bootstrap.preflight.PreflightCheck;
import org.graylog2.bootstrap.preflight.PreflightCheckException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreflightCheckService {
    private static final Logger LOG = LoggerFactory.getLogger(PreflightCheckService.class);
    private final Map<String, PreflightCheck> preflightChecks;
    private final boolean skipPreflightChecks;

    @Inject
    public PreflightCheckService(Map<String, PreflightCheck> preflightChecks, @Named(value="skip_preflight_checks") boolean skipPreflightChecks) {
        this.preflightChecks = preflightChecks;
        this.skipPreflightChecks = skipPreflightChecks;
    }

    public void runChecks() throws PreflightCheckException {
        if (this.skipPreflightChecks) {
            LOG.info("Skipping preflight checks");
            return;
        }
        try {
            this.preflightChecks.values().forEach(PreflightCheck::runCheck);
        }
        catch (PreflightCheckException e) {
            LOG.error("Preflight check failed with error: {}", (Object)e.getLocalizedMessage());
            throw e;
        }
    }
}

