/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bootstrap.preflight.PreflightConfig;
import org.graylog2.bootstrap.preflight.PreflightConfigImpl;
import org.graylog2.bootstrap.preflight.PreflightConfigResult;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.database.ValidationException;

public class PreflightConfigServiceImpl
extends PersistedServiceImpl
implements PreflightConfigService {
    @Inject
    public PreflightConfigServiceImpl(MongoConnection connection) {
        super(connection);
    }

    @Override
    public Optional<PreflightConfig> getPersistedConfig() {
        DBObject doc = this.findOne(PreflightConfigImpl.class, (DBObject)new BasicDBObject());
        return Optional.ofNullable(doc).map(o -> new PreflightConfigImpl((ObjectId)o.get("_id"), o.toMap()));
    }

    @Override
    public PreflightConfig saveConfiguration() throws ValidationException {
        ImmutableMap fields = ImmutableMap.of((Object)"result", (Object)((Object)PreflightConfigResult.FINISHED));
        PreflightConfigImpl config = new PreflightConfigImpl((Map<String, Object>)fields);
        String id = this.save(config);
        return this.getPersistedConfig().orElseThrow(() -> new IllegalStateException("Failed to obtain configuration that was just stored"));
    }
}

