/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.util.Objects;
import org.graylog.security.certutil.CaService;
import org.graylog.security.certutil.CaServiceImpl;
import org.graylog.security.certutil.keystore.storage.KeystoreContentMover;
import org.graylog.security.certutil.keystore.storage.SinglePasswordKeystoreContentMover;
import org.graylog2.Configuration;
import org.graylog2.bindings.providers.ClusterEventBusProvider;
import org.graylog2.bindings.providers.MongoConnectionProvider;
import org.graylog2.bootstrap.preflight.GraylogCertificateProvisioningPeriodical;
import org.graylog2.bootstrap.preflight.NullNotificationService;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.bootstrap.preflight.PreflightConfigServiceImpl;
import org.graylog2.bootstrap.preflight.PreflightJerseyService;
import org.graylog2.bootstrap.preflight.PreflightRestResourcesBinding;
import org.graylog2.bootstrap.preflight.web.PreflightBoot;
import org.graylog2.bootstrap.preflight.web.resources.CertificateRenewalPolicyResource;
import org.graylog2.bootstrap.preflight.web.resources.PreflightAssetsResource;
import org.graylog2.bootstrap.preflight.web.resources.PreflightResource;
import org.graylog2.bootstrap.preflight.web.resources.PreflightStatusResource;
import org.graylog2.cluster.ClusterConfigServiceImpl;
import org.graylog2.cluster.NodeService;
import org.graylog2.cluster.NodeServiceImpl;
import org.graylog2.cluster.leader.LeaderElectionModule;
import org.graylog2.cluster.lock.LockServiceModule;
import org.graylog2.database.MongoConnection;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.events.ClusterEventCleanupPeriodical;
import org.graylog2.events.ClusterEventPeriodical;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.bindings.providers.EventBusProvider;
import org.graylog2.shared.bindings.providers.ServiceManagerProvider;
import org.graylog2.shared.initializers.PeriodicalsService;

public class PreflightWebModule
extends Graylog2Module {
    public static final String FEATURE_FLAG_PREFLIGHT_WEB_ENABLED = "preflight_web";
    private final Configuration configuration;

    public PreflightWebModule(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    protected void configure() {
        this.bind(ServiceManager.class).toProvider(ServiceManagerProvider.class).asEagerSingleton();
        this.bind(MongoConnection.class).toProvider(MongoConnectionProvider.class);
        this.bind(NodeService.class).to(NodeServiceImpl.class);
        this.bind(KeystoreContentMover.class).to(SinglePasswordKeystoreContentMover.class).asEagerSingleton();
        this.bind(ClusterConfigService.class).to(ClusterConfigServiceImpl.class);
        this.bind(CaService.class).to(CaServiceImpl.class);
        this.bind(PreflightConfigService.class).to(PreflightConfigServiceImpl.class);
        this.bind(PreflightBoot.class).asEagerSingleton();
        this.bind(NotificationService.class).to(NullNotificationService.class);
        this.addPreflightRestResource(PreflightResource.class);
        this.addPreflightRestResource(CertificateRenewalPolicyResource.class);
        this.addPreflightRestResource(PreflightStatusResource.class);
        this.addPreflightRestResource(PreflightAssetsResource.class);
        Multibinder periodicalBinder = Multibinder.newSetBinder((Binder)this.binder(), Periodical.class);
        periodicalBinder.addBinding().to(GraylogCertificateProvisioningPeriodical.class);
        periodicalBinder.addBinding().to(ClusterEventPeriodical.class);
        periodicalBinder.addBinding().to(ClusterEventCleanupPeriodical.class);
        Multibinder serviceBinder = Multibinder.newSetBinder((Binder)this.binder(), Service.class);
        serviceBinder.addBinding().to(PreflightJerseyService.class);
        serviceBinder.addBinding().to(PeriodicalsService.class);
        this.install((Module)new LockServiceModule());
        this.install((Module)new LeaderElectionModule(this.configuration));
        this.bind(ClusterEventBus.class).toProvider(ClusterEventBusProvider.class).asEagerSingleton();
        this.bind(EventBus.class).toProvider(EventBusProvider.class).asEagerSingleton();
        MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<MessageInput.Factory<? extends MessageInput>>(){});
    }

    protected void addPreflightRestResource(Class<?> restResourceClass) {
        this.preflightRestResourceBinder().addBinding().toInstance(restResourceClass);
    }

    private Multibinder<Class<?>> preflightRestResourceBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<?>>(){}, PreflightRestResourcesBinding.class);
    }
}

