/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web;

import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.Configuration;
import org.graylog2.bootstrap.preflight.PreflightConfigService;

@Singleton
public class PreflightBoot {
    private final boolean isFreshInstallation;
    private final List<URI> hosts;
    private final PreflightConfigService preflightConfigServiceIf;
    private final Configuration configuration;

    @Inject
    public PreflightBoot(@Named(value="isFreshInstallation") boolean isFreshInstallation, @Named(value="elasticsearch_hosts") List<URI> hosts, PreflightConfigService preflightConfigServiceIf, Configuration configuration) {
        this.isFreshInstallation = isFreshInstallation;
        this.hosts = hosts;
        this.preflightConfigServiceIf = preflightConfigServiceIf;
        this.configuration = configuration;
    }

    public boolean shouldRunPreflightWeb() {
        if (this.configuration.enablePreflightWebserver()) {
            return true;
        }
        if (!this.isFreshInstallation) {
            return false;
        }
        if (!this.hosts.isEmpty()) {
            return false;
        }
        return !this.preflightConfigServiceIf.getPersistedConfig().isPresent();
    }
}

