/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.preflight;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.DBCollection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.cluster.preflight.DataNodeProvisioningService;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.indices.MongoDbIndexTools;
import org.graylog2.shared.utilities.StringUtils;
import org.mongojack.DBQuery;
import org.mongojack.DBUpdate;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class DataNodeProvisioningServiceImpl
extends PaginatedDbService<DataNodeProvisioningConfig>
implements DataNodeProvisioningService {
    public static final String COLLECTION_NAME = "datanode_provisioning_config";
    private final JacksonDBCollection<DataNodeProvisioningConfig, String> dbCollection;

    @Inject
    public DataNodeProvisioningServiceImpl(MongoJackObjectMapperProvider mongoJackObjectMapperProvider, MongoConnection mongoConnection) {
        super(mongoConnection, mongoJackObjectMapperProvider, DataNodeProvisioningConfig.class, COLLECTION_NAME);
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), DataNodeProvisioningConfig.class, String.class, (ObjectMapper)mongoJackObjectMapperProvider.get());
        new MongoDbIndexTools(this.db).createUniqueIndex("node_id");
    }

    @Override
    public DataNodeProvisioningConfig getPreflightConfigFor(String nodeId) {
        return (DataNodeProvisioningConfig)this.dbCollection.findOne(DBQuery.is((String)"node_id", (Object)nodeId));
    }

    @Override
    public List<DataNodeProvisioningConfig> findAllNodesThatNeedAttention() {
        return this.streamQuery(DBQuery.notIn((String)"state", (Object[])new Object[]{DataNodeProvisioningConfig.State.CONNECTED})).toList();
    }

    @Override
    public void writeCsr(String nodeId, String csr) {
        WriteResult result = this.dbCollection.update(DBQuery.is((String)"node_id", (Object)nodeId), new DBUpdate.Builder().set("csr", (Object)csr).set("state", (Object)DataNodeProvisioningConfig.State.CSR), false, false);
        if (result.getN() != 1) {
            throw new RuntimeException(StringUtils.f("Failed to write node %s certificate", nodeId));
        }
    }

    @Override
    public void writeCert(String nodeId, String cert) {
        WriteResult result = this.dbCollection.update(DBQuery.is((String)"node_id", (Object)nodeId), new DBUpdate.Builder().set("certificate", (Object)cert).set("state", (Object)DataNodeProvisioningConfig.State.SIGNED), false, false);
        if (result.getN() != 1) {
            throw new RuntimeException(StringUtils.f("Failed to write node %s certificate", nodeId));
        }
    }

    @Override
    public Optional<String> readCert(String nodeId) {
        DataNodeProvisioningConfig config = (DataNodeProvisioningConfig)this.dbCollection.findOne(DBQuery.is((String)"node_id", (Object)nodeId));
        if (config != null) {
            return Optional.ofNullable(config.certificate());
        }
        return Optional.empty();
    }

    @Override
    public void changeState(String nodeId, DataNodeProvisioningConfig.State state) {
        WriteResult result = this.dbCollection.update(DBQuery.is((String)"node_id", (Object)nodeId), new DBUpdate.Builder().set("state", (Object)state), false, false);
        if (result.getN() != 1) {
            throw new RuntimeException(StringUtils.f("Failed to change node %s state", nodeId));
        }
    }

    @Override
    public void deleteAll() {
        this.dbCollection.drop();
    }
}

