/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.graylog2.configuration.converters.MajorVersionConverter;
import org.graylog2.configuration.converters.URIListConverter;
import org.graylog2.configuration.validators.ElasticsearchVersionValidator;
import org.graylog2.configuration.validators.HttpOrHttpsSchemeValidator;
import org.graylog2.configuration.validators.ListOfURIsWithHostAndSchemeValidator;
import org.graylog2.storage.SearchVersion;

public class ElasticsearchClientConfiguration {
    @Parameter(value="elasticsearch_version", converter=MajorVersionConverter.class, validators={ElasticsearchVersionValidator.class})
    SearchVersion elasticsearchVersion;
    @Parameter(value="elasticsearch_hosts", converter=URIListConverter.class, validators={ListOfURIsWithHostAndSchemeValidator.class})
    List<URI> elasticsearchHosts = new ArrayList<URI>();
    @Parameter(value="elasticsearch_connect_timeout", validators={PositiveDurationValidator.class})
    Duration elasticsearchConnectTimeout = Duration.seconds((long)10L);
    @Parameter(value="elasticsearch_socket_timeout", validators={PositiveDurationValidator.class})
    Duration elasticsearchSocketTimeout = Duration.seconds((long)60L);
    @Parameter(value="elasticsearch_idle_timeout")
    Duration elasticsearchIdleTimeout = Duration.seconds((long)-1L);
    @Parameter(value="elasticsearch_version_probe_attempts", validators={PositiveIntegerValidator.class})
    int elasticsearchVersionProbeAttempts = 0;
    @Parameter(value="elasticsearch_version_probe_delay", validators={PositiveDurationValidator.class})
    Duration elasticsearchVersionProbeDelay = Duration.seconds((long)5L);
    @Parameter(value="elasticsearch_max_total_connections", validators={PositiveIntegerValidator.class})
    int elasticsearchMaxTotalConnections = 200;
    @Parameter(value="elasticsearch_max_total_connections_per_route", validators={PositiveIntegerValidator.class})
    int elasticsearchMaxTotalConnectionsPerRoute = 20;
    @Parameter(value="elasticsearch_max_retries", validators={PositiveIntegerValidator.class})
    int elasticsearchMaxRetries = 2;
    @Parameter(value="elasticsearch_discovery_enabled")
    boolean discoveryEnabled = false;
    @Parameter(value="elasticsearch_node_activity_logger_enabled")
    boolean nodeActivityLogger = false;
    @Parameter(value="elasticsearch_discovery_filter")
    String discoveryFilter = null;
    @Parameter(value="elasticsearch_discovery_frequency", validators={PositiveDurationValidator.class})
    Duration discoveryFrequency = Duration.seconds((long)30L);
    @Parameter(value="elasticsearch_discovery_default_scheme", validators={HttpOrHttpsSchemeValidator.class})
    String defaultSchemeForDiscoveredNodes = "http";
    @Parameter(value="elasticsearch_discovery_default_user")
    String defaultUserForDiscoveredNodes = null;
    @Parameter(value="elasticsearch_discovery_default_password")
    String defaultPasswordForDiscoveredNodes = null;
    @Parameter(value="elasticsearch_compression_enabled")
    boolean compressionEnabled = false;
    @Parameter(value="elasticsearch_use_expect_continue")
    boolean useExpectContinue = true;
    @Parameter(value="elasticsearch_mute_deprecation_warnings")
    private boolean muteDeprecationWarnings = false;
    @Parameter(value="indexer_use_jwt_authentication")
    boolean indexerUseJwtAuthentication = false;
    @Parameter(value="indexer_jwt_auth_token_caching_duration")
    Duration indexerJwtAuthTokenCachingDuration = Duration.seconds((long)60L);
    @Parameter(value="indexer_jwt_auth_token_expiration_duration")
    Duration indexerJwtAuthTokenExpirationDuration = Duration.seconds((long)180L);
}

