/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.validators.InetPortValidator;
import com.google.common.base.Strings;
import java.net.URI;
import java.time.Duration;
import org.graylog2.configuration.converters.JavaDurationConverter;

public class EmailConfiguration {
    @Parameter(value="transport_email_enabled")
    private boolean enabled = false;
    @Parameter(value="transport_email_hostname")
    private String hostname;
    @Parameter(value="transport_email_port", validator=InetPortValidator.class)
    private int port = 25;
    @Parameter(value="transport_email_use_auth")
    private boolean useAuth = false;
    @Parameter(value="transport_email_use_tls")
    private boolean useTls = true;
    @Parameter(value="transport_email_use_ssl")
    private boolean useSsl = false;
    @Parameter(value="transport_email_auth_username")
    private String username;
    @Parameter(value="transport_email_auth_password")
    private String password;
    @Parameter(value="transport_email_from_email")
    private String fromEmail;
    @Parameter(value="transport_email_web_interface_url")
    private URI webInterfaceUri;
    @Parameter(value="transport_email_socket_connection_timeout", converter=JavaDurationConverter.class, validators={MillisecondDurationValidator.class})
    private Duration socketConnectionTimeout = Duration.ofSeconds(10L);
    @Parameter(value="transport_email_socket_timeout", converter=JavaDurationConverter.class, validators={MillisecondDurationValidator.class})
    private Duration socketTimeout = Duration.ofSeconds(10L);

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isUseAuth() {
        return this.useAuth;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public URI getWebInterfaceUri() {
        return this.webInterfaceUri;
    }

    @ValidatorMethod
    public void validateTlsSsl() throws ValidationException {
        if (this.isUseTls() && this.isUseSsl()) {
            throw new ValidationException("SMTP over SSL (SMTPS) and SMTP with STARTTLS cannot be used at the same time.");
        }
    }

    @ValidatorMethod
    public void validateHostname() throws ValidationException {
        if (this.isEnabled() && Strings.isNullOrEmpty((String)this.getHostname())) {
            throw new ValidationException("No hostname configured for email transport");
        }
    }

    public Duration getSocketConnectionTimeout() {
        return this.socketConnectionTimeout;
    }

    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public static class MillisecondDurationValidator
    implements Validator<Duration> {
        public void validate(String name, Duration value) throws ValidationException {
            try {
                long l = value.toNanos();
            }
            catch (ArithmeticException e) {
                throw new ValidationException("Parameter " + name + " exceeds the limit to allow representation as milliseconds: " + e.getLocalizedMessage());
            }
        }
    }
}

