/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.configuration.converters.JavaDurationConverter;

public class TelemetryConfiguration {
    public static final String TELEMETRY_ENABLED = "telemetry_enabled";
    public static final String TELEMETRY_CLUSTER_INFO_TTL = "telemetry_cluster_info_ttl";
    @Parameter(value="telemetry_api_key", required=true)
    private String telemetryApiKey = "phc_t3lgBB66QsPW4HEfiGopO14um4XGNtBcefEKYWelWda";
    @Parameter(value="telemetry_host")
    private String telemetryApiHost = "https://telemetry.graylog.cloud";
    @Parameter(value="telemetry_enabled")
    private boolean telemetryEnabled = true;
    @Parameter(value="telemetry_cluster_info_ttl", converter=JavaDurationConverter.class, validators={Minimum10MinuteValidator.class})
    private Duration telemetryClusterInfoTtl = Duration.ofMinutes(10L);

    @Nullable
    public String getTelemetryApiKey() {
        return this.telemetryApiKey;
    }

    public String getTelemetryApiHost() {
        return this.telemetryApiHost;
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public Duration getTelemetryClusterInfoTtl() {
        return this.telemetryClusterInfoTtl;
    }

    public Map<String, ?> telemetryFrontendSettings() {
        return Map.of("api_key", this.getTelemetryApiKey() != null ? this.getTelemetryApiKey() : "", "host", this.getTelemetryApiHost(), "enabled", this.isTelemetryEnabled());
    }

    public static class Minimum10MinuteValidator
    implements Validator<Duration> {
        public void validate(String name, Duration value) throws ValidationException {
            if (value != null && value.compareTo(Duration.ofMinutes(10L)) < 0) {
                throw new ValidationException("Parameter " + name + " should be at least 10 minutes (found " + value + ")");
            }
        }
    }
}

