/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration.converters;

import com.github.joschi.jadconfig.Converter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.joda.time.Period;

public class JavaDurationConverter
implements Converter<Duration> {
    public Duration convertFrom(String value) {
        if (value.startsWith("P")) {
            Period period = Period.parse((String)value);
            return Duration.parse(period.toString());
        }
        com.github.joschi.jadconfig.util.Duration jadDuration = com.github.joschi.jadconfig.util.Duration.parse((String)value);
        ChronoUnit chronoUnit = JavaDurationConverter.toChronoUnit(jadDuration.getUnit());
        return Duration.of(jadDuration.getQuantity(), chronoUnit);
    }

    public String convertTo(Duration value) {
        return value.toString();
    }

    public static ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError();
    }
}

