/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class URIListConverter
implements Converter<List<URI>> {
    private static final String SEPARATOR = ",";

    public List<URI> convertFrom(String value) {
        if (value == null) {
            throw new ParameterException("URI List must not be null.");
        }
        Iterable splittedUris = Splitter.on((String)SEPARATOR).omitEmptyStrings().trimResults().split((CharSequence)value);
        return StreamSupport.stream(splittedUris.spliterator(), false).map(this::constructURIFromString).collect(Collectors.toList());
    }

    public String convertTo(List<URI> value) {
        if (value == null) {
            throw new ParameterException("URI List must not be null.");
        }
        return Joiner.on((String)SEPARATOR).skipNulls().join(value);
    }

    private URI constructURIFromString(String value) {
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new ParameterException(e.getMessage(), (Throwable)e);
        }
    }
}

