/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.contentpacks.model.ContentPackInstallation;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.database.MongoConnection;
import org.graylog2.rest.models.system.contentpacks.responses.ContentPackMetadata;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

@Singleton
public class ContentPackInstallationPersistenceService {
    public static final String COLLECTION_NAME = "content_packs_installations";
    private final JacksonDBCollection<ContentPackInstallation, ObjectId> dbCollection;

    @Inject
    public ContentPackInstallationPersistenceService(MongoJackObjectMapperProvider mapperProvider, MongoConnection mongoConnection) {
        this((JacksonDBCollection<ContentPackInstallation, ObjectId>)JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), ContentPackInstallation.class, ObjectId.class, (ObjectMapper)mapperProvider.get()));
    }

    ContentPackInstallationPersistenceService(JacksonDBCollection<ContentPackInstallation, ObjectId> dbCollection) {
        this.dbCollection = dbCollection;
        dbCollection.createIndex((DBObject)new BasicDBObject("content_pack_id", (Object)1));
        dbCollection.createIndex((DBObject)new BasicDBObject("content_pack_id", (Object)1).append("content_pack_revision", (Object)1));
    }

    public Set<ContentPackInstallation> loadAll() {
        try (DBCursor installations = this.dbCollection.find();){
            ImmutableSet immutableSet = ImmutableSet.copyOf((Iterator)installations);
            return immutableSet;
        }
    }

    public Set<ContentPackInstallation> findByContentPackIds(Set<ModelId> ids) {
        Set stringIds = ids.stream().map(x -> x.toString()).collect(Collectors.toSet());
        DBObject query = BasicDBObjectBuilder.start().push("content_pack_id").append("$in", stringIds).get();
        DBCursor result = this.dbCollection.find(query);
        return ImmutableSet.copyOf((Iterable)result);
    }

    public Optional<ContentPackInstallation> findById(ObjectId id) {
        ContentPackInstallation installation = (ContentPackInstallation)this.dbCollection.findOneById((Object)id);
        return Optional.ofNullable(installation);
    }

    public Set<ContentPackInstallation> findByContentPackIdAndRevision(ModelId id, int revision) {
        DBQuery.Query query = (DBQuery.Query)DBQuery.is((String)"content_pack_id", (Object)id).is("content_pack_revision", (Object)revision);
        try (DBCursor installations = this.dbCollection.find(query);){
            ImmutableSet immutableSet = ImmutableSet.copyOf((Iterator)installations);
            return immutableSet;
        }
    }

    public Set<ContentPackInstallation> findByContentPackId(ModelId id) {
        DBQuery.Query query = DBQuery.is((String)"content_pack_id", (Object)id);
        try (DBCursor installations = this.dbCollection.find(query);){
            ImmutableSet immutableSet = ImmutableSet.copyOf((Iterator)installations);
            return immutableSet;
        }
    }

    public ContentPackInstallation insert(ContentPackInstallation installation) {
        WriteResult writeResult = this.dbCollection.insert((Object)installation);
        return (ContentPackInstallation)writeResult.getSavedObject();
    }

    public int deleteById(ObjectId id) {
        WriteResult writeResult = this.dbCollection.removeById((Object)id);
        return writeResult.getN();
    }

    public Map<ModelId, Map<Integer, ContentPackMetadata>> getInstallationMetadata(Set<ModelId> ids) {
        Set<ContentPackInstallation> contentPackInstallations = this.findByContentPackIds(ids);
        HashMap<ModelId, Map<Integer, ContentPackMetadata>> installationMetaData = new HashMap<ModelId, Map<Integer, ContentPackMetadata>>();
        for (ContentPackInstallation installation : contentPackInstallations) {
            HashMap<Integer, ContentPackMetadata> metadataMap = (HashMap<Integer, ContentPackMetadata>)installationMetaData.get(installation.contentPackId());
            if (metadataMap == null) {
                metadataMap = new HashMap<Integer, ContentPackMetadata>();
            }
            ContentPackMetadata metadata = (ContentPackMetadata)metadataMap.get(installation.contentPackRevision());
            int count = 1;
            if (metadata != null) {
                count = metadata.installationCount() + 1;
            }
            ContentPackMetadata newMetadata = ContentPackMetadata.create(count);
            metadataMap.put(installation.contentPackRevision(), newMetadata);
            installationMetaData.put(installation.contentPackId(), metadataMap);
        }
        return installationMetaData;
    }

    public long countInstallationOfEntityById(ModelId entityId) {
        String field = String.format(Locale.ROOT, "%s.%s", "entities", "id");
        return this.dbCollection.getCount(DBQuery.is((String)field, (Object)entityId));
    }

    public long countInstallationOfEntityByIdAndFoundOnSystem(ModelId entityId) {
        DBQuery.Query query = DBQuery.elemMatch((String)"entities", (DBQuery.Query)DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"found_on_system", (Object)true), DBQuery.is((String)"id", (Object)entityId.id())}));
        return this.dbCollection.getCount(query);
    }
}

