/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.entities.references.ReferenceMap;
import org.graylog2.contentpacks.model.entities.references.ReferenceMapUtils;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

public class WidgetConfig {
    private Map<String, Object> config;

    public WidgetConfig(ReferenceMap config, Map<String, ValueReference> parameters) {
        this.config = ReferenceMapUtils.toValueMap(config, parameters);
    }

    public Optional<String> getOptionalString(String key) {
        Object value = this.config.get(key);
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    public String getString(String key) throws ContentPackException {
        Object value = this.config.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        throw new ContentPackException("Could not find key " + key + " in config.");
    }

    public boolean getBoolean(String key) throws ContentPackException {
        Object value = this.config.get(key);
        if (value != null) {
            return (Boolean)value;
        }
        throw new ContentPackException("Could not find key " + key + " in config.");
    }

    public Optional<Boolean> getOptionalBoolean(String key) {
        Boolean value = (Boolean)this.config.get(key);
        return Optional.ofNullable(value);
    }

    public int getInteger(String key) {
        Object value = this.config.get(key);
        if (value != null) {
            return (Integer)value;
        }
        throw new ContentPackException("Could not find key " + key + " in config.");
    }

    public Optional<Integer> getOptionalInteger(String key) {
        Object value = this.config.get(key);
        if (value instanceof Integer) {
            return Optional.of((Integer)value);
        }
        return Optional.empty();
    }

    public List<Object> getList(String key) {
        Object value = this.config.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        return Collections.emptyList();
    }
}

