/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentstream.db;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog2.contentstream.db.ContentStreamUserSettings;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_ContentStreamUserSettings
extends ContentStreamUserSettings {
    @Nullable
    private final String id;
    private final String userId;
    private final Boolean contentStreamEnabled;
    private final Boolean releasesEnabled;
    private final List<String> topics;

    private AutoValue_ContentStreamUserSettings(@Nullable String id, String userId, Boolean contentStreamEnabled, Boolean releasesEnabled, List<String> topics) {
        this.id = id;
        this.userId = userId;
        this.contentStreamEnabled = contentStreamEnabled;
        this.releasesEnabled = releasesEnabled;
        this.topics = topics;
    }

    @Override
    @JsonProperty
    @Nullable
    @Id
    @ObjectId
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="user_id")
    public String userId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="content_stream_enabled")
    public Boolean contentStreamEnabled() {
        return this.contentStreamEnabled;
    }

    @Override
    @JsonProperty(value="releases_enabled")
    public Boolean releasesEnabled() {
        return this.releasesEnabled;
    }

    @Override
    @JsonProperty(value="content_stream_topics")
    public List<String> topics() {
        return this.topics;
    }

    public String toString() {
        return "ContentStreamUserSettings{id=" + this.id + ", userId=" + this.userId + ", contentStreamEnabled=" + this.contentStreamEnabled + ", releasesEnabled=" + this.releasesEnabled + ", topics=" + this.topics + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ContentStreamUserSettings) {
            ContentStreamUserSettings that = (ContentStreamUserSettings)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.userId.equals(that.userId()) && this.contentStreamEnabled.equals(that.contentStreamEnabled()) && this.releasesEnabled.equals(that.releasesEnabled()) && this.topics.equals(that.topics());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.userId.hashCode();
        h$ *= 1000003;
        h$ ^= this.contentStreamEnabled.hashCode();
        h$ *= 1000003;
        h$ ^= this.releasesEnabled.hashCode();
        h$ *= 1000003;
        return h$ ^= this.topics.hashCode();
    }

    static final class Builder
    extends ContentStreamUserSettings.Builder {
        private String id;
        private String userId;
        private Boolean contentStreamEnabled;
        private Boolean releasesEnabled;
        private List<String> topics;

        Builder() {
        }

        @Override
        public ContentStreamUserSettings.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public ContentStreamUserSettings.Builder userId(String userId) {
            if (userId == null) {
                throw new NullPointerException("Null userId");
            }
            this.userId = userId;
            return this;
        }

        @Override
        public ContentStreamUserSettings.Builder contentStreamEnabled(Boolean contentStreamEnabled) {
            if (contentStreamEnabled == null) {
                throw new NullPointerException("Null contentStreamEnabled");
            }
            this.contentStreamEnabled = contentStreamEnabled;
            return this;
        }

        @Override
        public ContentStreamUserSettings.Builder releasesEnabled(Boolean releasesEnabled) {
            if (releasesEnabled == null) {
                throw new NullPointerException("Null releasesEnabled");
            }
            this.releasesEnabled = releasesEnabled;
            return this;
        }

        @Override
        public ContentStreamUserSettings.Builder topics(List<String> topics) {
            if (topics == null) {
                throw new NullPointerException("Null topics");
            }
            this.topics = topics;
            return this;
        }

        @Override
        public ContentStreamUserSettings build() {
            if (this.userId == null || this.contentStreamEnabled == null || this.releasesEnabled == null || this.topics == null) {
                StringBuilder missing = new StringBuilder();
                if (this.userId == null) {
                    missing.append(" userId");
                }
                if (this.contentStreamEnabled == null) {
                    missing.append(" contentStreamEnabled");
                }
                if (this.releasesEnabled == null) {
                    missing.append(" releasesEnabled");
                }
                if (this.topics == null) {
                    missing.append(" topics");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ContentStreamUserSettings(this.id, this.userId, this.contentStreamEnabled, this.releasesEnabled, this.topics);
        }
    }
}

