/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.dbcatalog;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.graylog2.database.dbcatalog.DbEntityCatalogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbEntitiesCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(DbEntitiesCatalog.class);
    private final Map<String, DbEntityCatalogEntry> entitiesByCollectionName;
    private final Map<Class<?>, DbEntityCatalogEntry> entitiesByClass;

    public DbEntitiesCatalog(Collection<DbEntityCatalogEntry> entries) {
        this.entitiesByCollectionName = new HashMap<String, DbEntityCatalogEntry>(entries.size());
        this.entitiesByClass = new HashMap(entries.size());
        entries.forEach(this::add);
    }

    private void add(DbEntityCatalogEntry entry) {
        DbEntityCatalogEntry previousEntry = this.entitiesByCollectionName.put(entry.collection(), entry);
        if (previousEntry != null) {
            String errorMsg = "Two model classes associated with the same mongo collection : " + entry + " and " + previousEntry;
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        this.entitiesByClass.put(entry.modelClass(), entry);
    }

    public Optional<DbEntityCatalogEntry> getByModelClass(Class<?> modelClass) {
        return Optional.ofNullable(this.entitiesByClass.get(modelClass));
    }

    public Optional<DbEntityCatalogEntry> getByCollectionName(String collection) {
        return Optional.ofNullable(this.entitiesByCollectionName.get(collection));
    }

    public int size() {
        return this.entitiesByCollectionName.size();
    }
}

