/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.dbcatalog.impl;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.LinkedList;
import org.graylog2.database.DbEntity;
import org.graylog2.database.dbcatalog.DbEntitiesCatalog;
import org.graylog2.database.dbcatalog.DbEntityCatalogEntry;
import org.graylog2.database.dbcatalog.impl.DbEntitiesScanningMethod;
import org.graylog2.shared.plugins.ChainingClassLoader;

public class ClassGraphDbEntitiesScanningMethod
implements DbEntitiesScanningMethod {
    @Override
    public DbEntitiesCatalog scan(String[] packagesToScan, String[] packagesToExclude, ChainingClassLoader chainingClassLoader) {
        LinkedList<DbEntityCatalogEntry> dbEntities = new LinkedList<DbEntityCatalogEntry>();
        ClassGraph classGraph = new ClassGraph().enableAnnotationInfo().acceptPackages(packagesToScan).rejectPackages(packagesToExclude).filterClasspathElements(classpathElementPathStr -> classpathElementPathStr.contains("graylog")).disableRuntimeInvisibleAnnotations();
        if (chainingClassLoader != null) {
            for (ClassLoader cl : chainingClassLoader.getClassLoaders()) {
                classGraph = classGraph.addClassLoader(cl);
            }
        }
        try (ScanResult scanResult = classGraph.scan();){
            String annotationName = DbEntity.class.getCanonicalName();
            ClassInfoList classInfoList = scanResult.getClassesWithAnnotation(annotationName);
            for (ClassInfo classInfo : classInfoList) {
                AnnotationInfo annotationInfo = classInfo.getAnnotationInfo(annotationName);
                AnnotationParameterValueList paramVals = annotationInfo.getParameterValues();
                dbEntities.add(new DbEntityCatalogEntry(((AnnotationParameterValue)paramVals.get("collection")).getValue().toString(), ((AnnotationParameterValue)paramVals.get("titleField")).getValue().toString(), classInfo.loadClass(), ((AnnotationParameterValue)paramVals.get("readPermission")).getValue().toString()));
            }
            DbEntitiesCatalog dbEntitiesCatalog = new DbEntitiesCatalog(dbEntities);
            return dbEntitiesCatalog;
        }
    }
}

