/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.filtering;

import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.graylog2.database.filtering.Filter;
import org.graylog2.database.filtering.RangeFilter;
import org.graylog2.database.filtering.SingleValueFilter;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.search.SearchQueryField;
import org.joda.time.DateTime;

public class DbFilterExpressionParser {
    static final String FIELD_AND_VALUE_SEPARATOR = ":";
    static final String RANGE_VALUES_SEPARATOR = "><";
    static final String WRONG_FILTER_EXPR_FORMAT_ERROR_MSG = "Wrong filter expression, <field_name>:<field_value> format should be used";

    public List<Bson> parse(List<String> filterExpressions, List<EntityAttribute> attributes) {
        if (filterExpressions == null || filterExpressions.isEmpty()) {
            return List.of();
        }
        Map<String, List<Filter>> groupedByField = filterExpressions.stream().map(expr -> this.parseSingleExpressionInner((String)expr, attributes)).collect(Collectors.groupingBy(Filter::field));
        return groupedByField.values().stream().map(grouped -> grouped.stream().map(Filter::toBson).collect(Collectors.toList())).map(groupedFilters -> {
            if (groupedFilters.size() == 1) {
                return (Bson)groupedFilters.get(0);
            }
            return Filters.or((Iterable)groupedFilters);
        }).toList();
    }

    public Bson parseSingleExpression(String filterExpression, List<EntityAttribute> attributes) {
        Filter filter = this.parseSingleExpressionInner(filterExpression, attributes);
        return filter.toBson();
    }

    private Filter parseSingleExpressionInner(String filterExpression, List<EntityAttribute> attributes) {
        if (!filterExpression.contains(FIELD_AND_VALUE_SEPARATOR)) {
            throw new IllegalArgumentException(WRONG_FILTER_EXPR_FORMAT_ERROR_MSG);
        }
        String[] split = filterExpression.split(FIELD_AND_VALUE_SEPARATOR, 2);
        String fieldPart = split[0];
        if (fieldPart == null || fieldPart.isEmpty()) {
            throw new IllegalArgumentException(WRONG_FILTER_EXPR_FORMAT_ERROR_MSG);
        }
        String valuePart = split[1];
        if (valuePart == null || valuePart.isEmpty()) {
            throw new IllegalArgumentException(WRONG_FILTER_EXPR_FORMAT_ERROR_MSG);
        }
        EntityAttribute attributeMetaData = this.getAttributeMetaData(attributes, fieldPart);
        SearchQueryField.Type fieldType = attributeMetaData.type();
        if (this.isRangeValueExpression(valuePart, fieldType)) {
            if (valuePart.startsWith(RANGE_VALUES_SEPARATOR)) {
                return new RangeFilter(attributeMetaData.id(), null, this.extractValue(fieldType, valuePart.substring(RANGE_VALUES_SEPARATOR.length())));
            }
            if (valuePart.endsWith(RANGE_VALUES_SEPARATOR)) {
                return new RangeFilter(attributeMetaData.id(), this.extractValue(fieldType, valuePart.substring(0, valuePart.length() - RANGE_VALUES_SEPARATOR.length())), null);
            }
            String[] ranges = valuePart.split(RANGE_VALUES_SEPARATOR);
            return new RangeFilter(attributeMetaData.id(), this.extractValue(fieldType, ranges[0]), this.extractValue(fieldType, ranges[1]));
        }
        return new SingleValueFilter(attributeMetaData.id(), this.extractValue(fieldType, valuePart));
    }

    private Object extractValue(SearchQueryField.Type fieldType, String valuePart) {
        Object converted = fieldType.getMongoValueConverter().apply(valuePart);
        if (converted instanceof DateTime && fieldType == SearchQueryField.Type.DATE) {
            return ((DateTime)converted).toDate();
        }
        return converted;
    }

    private EntityAttribute getAttributeMetaData(List<EntityAttribute> attributes, String attributeName) {
        EntityAttribute matchingByTitle = null;
        for (EntityAttribute attr : attributes) {
            if (attributeName.equals(attr.id()) && this.isFilterable(attr)) {
                return attr;
            }
            if (!attributeName.equalsIgnoreCase(attr.title()) || !this.isFilterable(attr)) continue;
            matchingByTitle = attr;
        }
        if (matchingByTitle != null) {
            return matchingByTitle;
        }
        throw new IllegalArgumentException(attributeName + " is not a field that can be used for filtering");
    }

    private boolean isRangeValueExpression(String valuePart, SearchQueryField.Type fieldType) {
        return SearchQueryField.Type.NUMERIC_TYPES.contains((Object)fieldType) && valuePart.contains(RANGE_VALUES_SEPARATOR);
    }

    private boolean isFilterable(EntityAttribute attr) {
        return Boolean.TRUE.equals(attr.filterable());
    }
}

